/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.cache.redis;

import com.ohaotian.plugin.common.util.SerializationUtils;
import java.util.Set;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisCluster;

public class Redis2Server {
    private JedisConnectionFactory jedisConnectionFactory;

    public JedisConnectionFactory getJedisConnectionFactory() {
        return this.jedisConnectionFactory;
    }

    public void setJedisConnectionFactory(JedisConnectionFactory jedisConnectionFactory) {
        this.jedisConnectionFactory = jedisConnectionFactory;
    }

    private JedisCluster getJedis() {
        RedisClusterConnection redisClusterConnection = this.jedisConnectionFactory.getClusterConnection();
        return (JedisCluster)redisClusterConnection.getNativeConnection();
    }

    public synchronized Object get(String key) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        byte[] value = jedis.get(key.getBytes());
        return value == null ? null : SerializationUtils.deserializeSlightly((byte[])value);
    }

    public synchronized void put(String key, String value, int expire) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        jedis.set(key.getBytes(), SerializationUtils.serializeSlightly((Object)value));
        if (expire != 0) {
            jedis.expire(key.getBytes(), expire);
        }
    }

    public synchronized void putHasSet(String key, String value, int expire) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        jedis.sadd(key, new String[]{value});
        if (expire != 0) {
            jedis.expire(key, expire);
        }
    }

    public Set<String> getHasSet(String key) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        return jedis.smembers(key);
    }

    public void del(String key) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        jedis.del(key);
    }

    public synchronized void setValueExpireTimeAt(String key, Long expire) {
        JedisCluster jedis = null;
        jedis = this.getJedis();
        if (expire != 0L) {
            jedis.expireAt(key.getBytes(), expire.longValue());
        }
    }
}

