/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.cache.redis;

import com.cgd.base.cache.CacheManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisClusterException;

public class RedisClusterManager
implements CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisClusterManager.class);
    private JedisCluster jedisCluster;
    private String host;
    private int timeout;
    private String pwd;
    private int soTimeOut;
    private int maxAttemts;
    private int expire = 0;

    public void init() {
        if (this.jedisCluster == null) {
            String clusterNodes = this.host;
            String[] cNodes = clusterNodes.split(",");
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String node : cNodes) {
                String[] hp = node.split(":");
                nodes.add(new HostAndPort(hp[0], Integer.parseInt(hp[1])));
            }
            this.jedisCluster = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.pwd) ? new JedisCluster(nodes, this.timeout, this.soTimeOut, this.maxAttemts, this.pwd, (GenericObjectPoolConfig)new JedisPoolConfig()) : new JedisCluster(nodes, this.timeout, this.soTimeOut, this.maxAttemts, (GenericObjectPoolConfig)new JedisPoolConfig());
        }
    }

    @Override
    public byte[] get(byte[] key) {
        return this.getJedisCluster().get(key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value) {
        JedisCluster jdc = this.getJedisCluster();
        jdc.set(key, value);
        if (this.expire != 0) {
            jdc.expire(key, this.expire);
        }
        return value;
    }

    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        JedisCluster jdc = this.getJedisCluster();
        jdc.set(key, value);
        if (expire != 0) {
            jdc.expire(key, expire);
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        this.getJedisCluster().del(key);
    }

    @Override
    public void flushDB() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public Set<byte[]> keys(String pattern) {
        TreeSet<byte[]> keys = new TreeSet<byte[]>();
        JedisCluster jdc = this.getJedisCluster();
        Map clusterNodes = jdc.getClusterNodes();
        for (Map.Entry entry : clusterNodes.entrySet()) {
            JedisPool jedisPool = (JedisPool)clusterNodes.get(entry.getKey());
            try {
                Jedis jedisConn = jedisPool.getResource();
                Throwable throwable = null;
                try {
                    keys.addAll(jedisConn.keys(pattern.getBytes()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedisConn == null) continue;
                    if (throwable != null) {
                        try {
                            jedisConn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedisConn.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Getting keys error: {}", (Object)pattern, (Object)e);
            }
        }
        return keys;
    }

    @Override
    public Long dbSize() {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        JedisCluster jc = this.getJedisCluster();
        if (expire != 0) {
            jc.expire(key, expire);
        }
    }

    @Override
    public Long getExpireTimeByKey(byte[] key) {
        return this.getJedisCluster().ttl(key);
    }

    @Override
    public Long incr(byte[] key) {
        return this.getJedisCluster().incr(key);
    }

    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        JedisCluster jc = this.getJedisCluster();
        Long num = jc.incr(key);
        jc.expire(key, expire);
        return num;
    }

    @Override
    public Long getIncr(byte[] key) {
        return this.getJedisCluster().incrBy(key, 1L);
    }

    @Override
    public void setValueExpireTimeAt(byte[] key, Long expire) {
        if (expire != 0L) {
            this.getJedisCluster().expireAt(key, expire.longValue());
        }
    }

    @Override
    public boolean setNx(String key, String value, Long seconds) {
        String nx = this.getJedisCluster().set(key, value, "NX", "EX", seconds.longValue());
        return !StringUtils.isEmpty((Object)nx) && "OK".equals(nx);
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public int getSoTimeOut() {
        return this.soTimeOut;
    }

    public void setSoTimeOut(int soTimeOut) {
        this.soTimeOut = soTimeOut;
    }

    public int getMaxAttemts() {
        return this.maxAttemts;
    }

    public void setMaxAttemts(int maxAttemts) {
        this.maxAttemts = maxAttemts;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }
}

