/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.cache.redis;

import com.cgd.base.cache.CacheManager;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager
implements CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisManager.class);
    private String host = "127.0.0.1";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "";
    private JedisPool jedisPool = null;

    public void init() {
        LOGGER.info("{}\u521d\u59cb\u5316host{}", (Object)this.jedisPool, (Object)this.host);
        if (this.jedisPool == null) {
            this.jedisPool = this.password != null && !"".equals(this.password) ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password) : (this.timeout != 0 ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] get(byte[] key) {
        byte[] value = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            value = jedis.get(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] set(byte[] key, byte[] value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, this.expire);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] set(byte[] key, byte[] value, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
        return value;
    }

    @Override
    public synchronized void del(byte[] key) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.del(key);
        }
    }

    @Override
    public synchronized void flushDB() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.flushDB();
        }
    }

    @Override
    public synchronized Long dbSize() {
        Long dbSize = 0L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            dbSize = jedis.dbSize();
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<byte[]> keys(String pattern) {
        Set keys = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            keys = jedis.keys(pattern.getBytes());
        }
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setValueExpireTime(byte[] key, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setValueExpireTimeAt(byte[] key, Long expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (expire != 0L) {
                jedis.expireAt(key, expire.longValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setNx(String key, String value, Long seconds) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String nx = jedis.set(key, value, "NX", "EX", seconds.longValue());
            if (!StringUtils.isEmpty((Object)nx) && "OK".equals(nx)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            expireTime = jedis.ttl(key);
        }
        return expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incr(key);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incr(key);
            jedis.expire(key, expire);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getIncr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            byte[] bnum = jedis.get(key);
            String numStr = bnum == null ? null : new String(bnum);
            num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        }
        return num;
    }
}

