/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.dict.manager;

import com.cgd.base.dict.config.DictConfig;
import com.cgd.base.dict.config.EntityConfig;
import com.cgd.base.dict.config.PropConfig;
import com.cgd.base.dict.manager.DictAccess;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DictsManager {
    private static final Logger log = LoggerFactory.getLogger(DictsManager.class);
    private String config;
    private DictAccess dbAccess;
    private DictAccess cacheAccess;
    private DictConfig dictcfg = new DictConfig();

    public DictsManager(String config, DictAccess dbAccess, DictAccess cacheAccess) {
        this.config = config;
        this.dbAccess = dbAccess;
        this.cacheAccess = cacheAccess;
        this.parseMapping();
        dbAccess.initConfig(this.dictcfg);
        if (!this.dictcfg.isLazyInitCache()) {
            cacheAccess.initConfig(this.dictcfg);
        }
    }

    private void parseMapping() {
        Document doc;
        SAXReader reader = new SAXReader();
        try {
            doc = reader.read(DictsManager.class.getResourceAsStream(this.config));
        }
        catch (DocumentException e) {
            throw new RuntimeException("\u5b57\u5178\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25...", e);
        }
        log.info(" start load dict mapping....");
        Element root = doc.getRootElement();
        if (root != null) {
            Element ens;
            String type;
            Element commcol;
            Attribute ds;
            Attribute initcable;
            Element gl = root.element("global");
            Attribute cable = gl.attribute("cachable");
            if (cable != null) {
                this.dictcfg.setUseCache(cable.getValue());
                log.debug("       load the dict cacheflag success...");
            }
            if ((initcable = gl.attribute("lazyInitCache")) != null) {
                this.dictcfg.setLazyInitCache(initcable.getValue());
                log.debug("       load the dict initcacheflag success...");
            }
            if ((ds = gl.attribute("ds")) == null) {
                throw new RuntimeException("\u5b57\u5178\u914d\u7f6e\u6587\u4ef6\u9ed8\u8ba4\u6570\u636e\u6e90\u672a\u914d\u7f6e...");
            }
            this.dictcfg.setDs(ds.getValue());
            log.debug("        load the dict dataSource success...");
            Element table = gl.element("table");
            if (table != null) {
                Attribute tablename = table.attribute("name");
                this.dictcfg.setBigTableName(tablename.getValue());
                Attribute tree = table.attribute("tree");
                if (tree != null) {
                    this.dictcfg.setTreeBigTable(tree.getValue().equalsIgnoreCase("true"));
                }
                log.debug("       load the dict common table success...");
            }
            if ((commcol = gl.element("column")) != null) {
                Attribute cpk = commcol.attribute("pk");
                Attribute ccnt = commcol.attribute("content");
                this.dictcfg.setCommonPK(cpk.getValue());
                this.dictcfg.setCommonCnt(ccnt.getValue());
                Attribute parent = commcol.attribute("parent");
                Attribute rowid = commcol.attribute("rowid");
                this.dictcfg.setParent(parent.getValue());
                this.dictcfg.setRowid(rowid.getValue());
                Attribute orderby = commcol.attribute("orderby");
                if (orderby != null) {
                    this.dictcfg.setOrderby(orderby.getValue());
                    log.debug("        load the dict orderby success...");
                }
                log.debug("       load the dict common column success...");
            }
            if ((type = (ens = root.element("entities")).attributeValue("tabletype")) == null) {
                type = "0";
            }
            this.dictcfg.setTableType(type);
            log.debug("        loaded the dict entity type[" + type + "]...");
            log.debug("        start load the dict entity list...");
            Iterator dics = ens.elementIterator("entity");
            while (dics.hasNext()) {
                String tabletype;
                Attribute whereAttrib;
                String tm;
                EntityConfig encfg = new EntityConfig();
                Element en = (Element)dics.next();
                Attribute alisaatt = en.attribute("alisa");
                Attribute nameatt = en.attribute("name");
                String enName = nameatt.getValue();
                if (enName == null) {
                    throw new RuntimeException("\u5b9e\u4f53\u540d[name]\u4e0d\u80fd\u4e3a\u7a7a...");
                }
                encfg.setEntityname(enName);
                String alisa = enName;
                if (alisaatt != null && (tm = alisaatt.getValue()) != null && !tm.trim().equals("")) {
                    alisa = tm;
                }
                encfg.setAlisaname(alisa);
                Attribute dsatt = en.attribute("ds");
                String enDS = null;
                enDS = dsatt != null ? dsatt.getValue() : this.dictcfg.getDs();
                encfg.setDs(enDS);
                Attribute orderatt = en.attribute("orderby");
                if (orderatt != null) {
                    encfg.setOrderby(orderatt.getValue());
                }
                if ((whereAttrib = en.attribute("where")) != null) {
                    encfg.setWhere(whereAttrib.getValue().replaceAll("&lt;", "<"));
                }
                if ((tabletype = en.attributeValue("tabletype")) == null) {
                    tabletype = this.dictcfg.getTableType();
                }
                encfg.setTabletype(tabletype);
                if (tabletype.equalsIgnoreCase("0")) {
                    encfg.setPkname(en.attributeValue("pk"));
                    encfg.setDescname(en.attributeValue("content"));
                    encfg.setDyna(en.attributeValue("dyna"));
                } else {
                    encfg.setPkname(this.dictcfg.getCommonPK());
                    encfg.setDescname(this.dictcfg.getCommonCnt());
                }
                this.dictcfg.addEntiy2Alisa(enName, alisa);
                Iterator props = en.elementIterator("property");
                while (props.hasNext()) {
                    Element prop = (Element)props.next();
                    String column = prop.attributeValue("column");
                    PropConfig pc = new PropConfig(column);
                    encfg.addProps(pc);
                }
                log.debug("               load the dict [ " + alisa + " ]");
                this.dictcfg.addEntity(encfg.getAlisaname(), encfg);
            }
        }
        log.debug("complete load the dict entity list...");
        log.info(" load  dicts mapping successful...");
    }

    public DictAccess getAccess() {
        if (this.dictcfg.isUseCache()) {
            return this.cacheAccess;
        }
        return this.dbAccess;
    }
}

