/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.file.ftp;

import com.cgd.base.file.ftp.FtpConfig;
import com.cgd.base.util.SessionChannelUtil;
import com.cgd.common.exception.ResourceException;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FtpUtil.class);

    public static void uploadFile(File file, FtpConfig ftp, String uploadPath) {
        String fileName = file.getName();
        try (FileInputStream fis = new FileInputStream(file);){
            FtpUtil.uploadFileByInputStream(fileName, ftp, fis, uploadPath);
        }
        catch (IOException e) {
            LOG.error("\u8bfb\u53d6\u6587\u4ef6{}IO\u5f02\u5e38", (Object)fileName, (Object)e);
            throw new ResourceException("F008", "\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38");
        }
    }

    private static void closeResources(ChannelSftp channelSftp, SessionChannelUtil scu) {
        if (scu != null) {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                LOG.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519!", (Throwable)e);
            }
        }
        if (channelSftp != null) {
            channelSftp.exit();
        }
    }

    private static void logAndThrowFtpException(FtpConfig ftp, String uploadPath, Exception e) {
        String errorMsg = String.format("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:%s,\u7528\u6237\u540d:%s,\u7aef\u53e3:%d\u3011\u540c\u65f6\u68c0\u67e5\u8def\u5f84\u3010%s\u662f\u5426\u6709\u6743\u9650\u3011", ftp.getFileHost(), ftp.getFileUser(), ftp.getFilePort(), uploadPath);
        LOG.error(errorMsg, (Throwable)e);
        throw new ResourceException("F007", errorMsg, e);
    }

    private static void completeFileUpload(String uploadPath, ChannelSftp channelSftp, String newFileName) throws SftpException {
        try {
            channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
        }
        catch (SftpException e) {
            channelSftp.rm(uploadPath + newFileName);
            channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
        }
    }

    private static void ensureDirectoryExists(String uploadPath, ChannelSftp channelSftp) throws SftpException {
        try {
            Vector content = channelSftp.ls(uploadPath);
            if (content == null || content.isEmpty()) {
                channelSftp.mkdir(uploadPath);
            }
        }
        catch (SftpException e) {
            LOG.error("SFTP ERROR", (Throwable)e);
            channelSftp.mkdir(uploadPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFileByInputStream(String fileName, FtpConfig ftp, InputStream fis, String uploadPath) {
        String newFileName = fileName;
        SessionChannelUtil scu = null;
        ChannelSftp channelSftp = null;
        try {
            scu = new SessionChannelUtil();
            Session session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            FtpUtil.ensureDirectoryExists(uploadPath, channelSftp);
            channelSftp.put(fis, uploadPath + newFileName + ".tmp", 0);
            FtpUtil.completeFileUpload(uploadPath, channelSftp, newFileName);
            FtpUtil.closeResources(channelSftp, scu);
        }
        catch (JSchException | SftpException e) {
            FtpUtil.logAndThrowFtpException(ftp, uploadPath, (Exception)e);
        }
        finally {
            FtpUtil.closeResources(channelSftp, scu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            String dir = System.getProperty("java.io.tmpdir");
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            fileName = dir + File.separator + fileName;
            channelSftp.get(filePath, fileName);
            LOG.debug("download FileName:{}", (Object)fileName);
        }
        catch (SftpException e) {
            throw new ResourceException("F007", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            FtpUtil.logAndThrowFtpException(ftp, filePath, e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                LOG.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
            }
        }
        return new File(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listFiles(String filePath, String suffix, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            Vector files = channelSftp.ls(filePath);
            for (Object object : files) {
                String curStr = object.toString();
                if (!(curStr = curStr.substring(curStr.lastIndexOf(" ") + 1)).contains(suffix)) continue;
                fileList.add(curStr);
            }
        }
        catch (Exception e) {
            LOG.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3002\u8be6\u7ec6\u4fe1\u606f\u5df2\u8bb0\u5f55\u65e5\u5fd7\u3002", (Throwable)e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                LOG.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3002\u8be6\u7ec6\u4fe1\u606f\u5df2\u8bb0\u5f55\u65e5\u5fd7\u3002", (Throwable)e);
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            channelSftp.rm(filePath);
        }
        catch (Exception e) {
            FtpUtil.logAndThrowFtpException(ftp, filePath, e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                LOG.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
            }
        }
    }
}

