/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.file.minio;

import com.aliyun.oss.internal.Mimetypes;
import com.cgd.base.file.minio.MinioConfig;
import com.cgd.common.exception.ResourceException;
import com.cgd.common.util.SslHttpsUtil;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MinioUtil.class);
    private static MinioClient minioClient;

    public static File downloadFile(String filePath, MinioConfig minioConfig) {
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."));
        return MinioUtil.minioDownloadFile(filePath, minioConfig, fileName);
    }

    private static File minioDownloadFile(String filePath, MinioConfig minioConfig, String fileName) {
        String dir = System.getProperty("java.io.tmpdir");
        fileName = dir + File.separator + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try (GetObjectResponse ins = MinioUtil.getMinioClient(minioConfig).getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(minioConfig.getBucketName())).object(filePath)).build());
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dir));){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception ie) {
            LOG.error("\u4eceminios\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + minioConfig.getBucketName() + ";accesskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, (Throwable)ie);
            throw new ResourceException("8888", "\u4eceMINIO\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
        return dirFile;
    }

    public static MinioClient getMinioClient(MinioConfig minioConfig) {
        if (minioClient == null) {
            minioClient = MinioClient.builder().endpoint(minioConfig.getEndPoint()).credentials(minioConfig.getAccessKeyId(), minioConfig.getAccessKeySecret()).httpClient(SslHttpsUtil.getUnsafeOkHttpClient()).build();
        }
        return minioClient;
    }

    public static File downloadFileNewName(String name, String filePath, MinioConfig minioConfig) {
        String fileName = name + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        return MinioUtil.minioDownloadFile(filePath, minioConfig, fileName);
    }

    public static void uploadFile(File file, MinioConfig minioConfig, String sysFileServicePath) {
        String fileName = file.getName();
        String fileKey = sysFileServicePath + fileName;
        try (FileInputStream inputStream = new FileInputStream(file);){
            MinioUtil.getMinioClient(minioConfig).putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(minioConfig.getBucketName())).object(fileKey)).stream((InputStream)inputStream, (long)((InputStream)inputStream).available(), -1L).contentType(Mimetypes.getInstance().getMimetype(fileKey)).build());
        }
        catch (IOException e) {
            LOG.error("\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        catch (ServerException e) {
            LOG.error("\u8fde\u63a5\u8fdc\u7a0bminio\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (InsufficientDataException e) {
            LOG.error("\u6570\u636e\u4f20\u8f93\u672a\u5b8c\u6210\u9884\u671f\u64cd\u4f5c\uff01", (Throwable)e);
        }
        catch (ErrorResponseException e) {
            LOG.error("MINIO\u54cd\u5e94\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("MINIO\u8ba4\u8bc1\u52a0\u5bc6\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error("MINIO\u8ba4\u8bc1\u7684key\u4e0d\u53ef\u7528\uff01", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            LOG.error("MINIO\u54cd\u5e94\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (XmlParserException e) {
            LOG.error("XML\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (InternalException e) {
            LOG.error("\u5185\u90e8\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void uploadFileByInputStream(String fileName, MinioConfig minioConfig, InputStream inputStream, String sysFileServicePath) {
        String fileKey = sysFileServicePath + fileName;
        try {
            MinioUtil.getMinioClient(minioConfig).putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(minioConfig.getBucketName())).object(fileKey)).stream(inputStream, (long)inputStream.available(), -1L).contentType(Mimetypes.getInstance().getMimetype(fileKey)).build());
        }
        catch (IOException e) {
            LOG.error("\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        catch (ServerException e) {
            LOG.error("\u8fde\u63a5\u8fdc\u7a0bminio\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (InsufficientDataException e) {
            LOG.error("\u6570\u636e\u4f20\u8f93\u672a\u5b8c\u6210\u9884\u671f\u64cd\u4f5c\uff01", (Throwable)e);
        }
        catch (ErrorResponseException e) {
            LOG.error("MINIO\u54cd\u5e94\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("MINIO\u8ba4\u8bc1\u52a0\u5bc6\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error("MINIO\u8ba4\u8bc1\u7684key\u4e0d\u53ef\u7528\uff01", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            LOG.error("MINIO\u54cd\u5e94\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (XmlParserException e) {
            LOG.error("XML\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (InternalException e) {
            LOG.error("\u5185\u90e8\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void deleteFile(String fileKey, MinioConfig minioConfig) {
        if (fileKey.startsWith("/")) {
            fileKey = fileKey.substring(1);
        }
        try {
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(minioConfig.getBucketName())).object(fileKey)).build());
        }
        catch (Exception e) {
            LOG.error("minio\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }
}

