/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.file.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.cgd.base.file.oss.OssConfig;
import com.cgd.common.exception.ResourceException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OssUtil.class);
    private static OSSClient ossClient;

    private OssUtil() {
        throw new UnsupportedOperationException("OssUtil\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static OSSClient getOssclient(OssConfig ossConfig) {
        if (ossClient == null) {
            ClientConfiguration conf = new ClientConfiguration();
            conf.setSupportCname(false);
            ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), conf);
        }
        return ossClient;
    }

    public static void uploadFile(File file, OssConfig ossConfig, String uploadPath) {
        String fileName = file.getName();
        try (FileInputStream content = new FileInputStream(file);){
            OSSClient ossClient = OssUtil.getOssclient(ossConfig);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, (InputStream)content, meta);
        }
        catch (OSSException e) {
            LOG.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error("\u68c0\u67e5\u6587\u4ef6\u3010" + fileName + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
        }
        catch (ClientException e) {
            LOG.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
    }

    public static void uploadFileByInputStream(String fileName, OssConfig ossConfig, InputStream inputStream, String uploadPath) throws OSSException, ClientException {
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, inputStream);
    }

    public static File downloadFile(String filePath, OssConfig ossConfig) {
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        return OssUtil.ossDownloadFile(filePath, ossConfig, fileName);
    }

    private static File ossDownloadFile(String filePath, OssConfig ossConfig, String fileName) {
        String dir = System.getProperty("java.io.tmpdir");
        fileName = dir + File.separator + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(ossConfig.getBucketName(), filePath);
            OssUtil.getOssclient(ossConfig).getObject(getObjectRequest, dirFile);
        }
        catch (ClientException | OSSException e) {
            LOG.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, e);
            throw new ResourceException("8888", "\u4eceOSS\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
        return dirFile;
    }

    public static File downloadFileNewName(String name, String filePath, OssConfig ossConfig) {
        String fileName = name + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        return OssUtil.ossDownloadFile(filePath, ossConfig, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String filePath, OssConfig ossConfig) {
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        try {
            ossClient.deleteObject(ossConfig.getBucketName(), filePath);
        }
        catch (OSSException e) {
            LOG.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.", (Throwable)e);
        }
        catch (ClientException e) {
            LOG.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.", (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
    }

    public static BufferedInputStream getObject(OssConfig ossConfig, String key) {
        OSSClient ossClient = OssUtil.getOssclient(ossConfig);
        OSSObject object = ossClient.getObject(ossConfig.getBucketName(), key);
        return new BufferedInputStream(object.getObjectContent());
    }
}

