/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.Excel2003Reader;
import com.cgd.base.fileanalyzing.Excel2007Reader;
import com.cgd.base.fileanalyzing.IRowReader;
import com.cgd.base.fileanalyzing.TxtReader;
import com.cgd.common.exception.ResourceException;
import java.io.IOException;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FileReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(FileReaderUtil.class);
    public static final String EXCEL03_EXTENSION = ".xls";
    public static final String EXCEL07_EXTENSION = ".xlsx";
    public static final String TXT_EXTENSION = ".txt";

    private FileReaderUtil() {
        throw new UnsupportedOperationException("FileReaderUtil\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static <T> int readExcel(IRowReader<T> reader, String fileName) throws IOException, OpenXML4JException, SAXException {
        if (fileName.endsWith(EXCEL03_EXTENSION)) {
            Excel2003Reader<T> excel03 = new Excel2003Reader<T>();
            excel03.setRowReader(reader);
            excel03.process(fileName);
        } else if (fileName.endsWith(EXCEL07_EXTENSION)) {
            Excel2007Reader<T> excel07 = new Excel2007Reader<T>();
            excel07.setRowReader(reader);
            excel07.process(fileName);
        } else if (fileName.endsWith(TXT_EXTENSION)) {
            TxtReader<T> txt = new TxtReader<T>();
            txt.setRowReader(reader);
            txt.process(fileName);
        } else {
            log.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u6216txt\u3002");
            throw new ResourceException("S100", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u6216txt\u3002");
        }
        return reader.getTotalSize();
    }

    public static <T> List<T> readExcelByPage(IRowReader<T> reader, String fileName, int fromSize, int toSize) throws OpenXML4JException, IOException, SAXException {
        reader.setJustGetTotalSize(true);
        FileReaderUtil.readExcel(reader, fileName);
        reader.setJustGetTotalSize(false);
        reader.setFromSize(fromSize);
        reader.setToSize(toSize);
        reader.setReadByPage(true);
        FileReaderUtil.readExcel(reader, fileName);
        return reader.getFetchData();
    }

    public static <T> int readExcelByBtach(IRowReader<T> reader, String fileName, int batchNum) throws OpenXML4JException, IOException, SAXException {
        reader.setJustGetTotalSize(true);
        FileReaderUtil.readExcel(reader, fileName);
        reader.setJustGetTotalSize(false);
        reader.setToSize(batchNum);
        return FileReaderUtil.readExcel(reader, fileName);
    }
}

