/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.fileanalyzing.FileParserResult;
import com.cgd.base.fileanalyzing.ParserFactory;
import com.cgd.base.fileanalyzing.ParserRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTxtParser
extends ParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTxtParser.class);

    public SimpleTxtParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
            while ((line = reader.readLine()) != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (StringUtils.isBlank((CharSequence)line)) continue;
                map.put(indexToFieldNameRule.getString("0"), line.trim());
                result.add(map);
            }
        }
        catch (IOException ex) {
            LOG.error("\u6587\u672c\u89e3\u6790\u5f02\u5e38", (Throwable)ex);
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }
}

