/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.IRowReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TxtReader.class);
    private List<String> rowlist = new ArrayList<String>();
    private IRowReader<T> rowReader;

    public IRowReader<T> getRowReader() {
        return this.rowReader;
    }

    public void setRowReader(IRowReader<T> rowReader) {
        this.rowReader = rowReader;
    }

    public void process(String fileName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(fileName)));){
            String line = null;
            String separator = this.rowReader.getSeparator();
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line)) continue;
                for (String value : line.split(separator)) {
                    this.rowlist.add(value);
                }
                this.rowReader.setRows(0, 0, this.rowlist);
                this.rowlist.clear();
            }
        }
        catch (Exception ex) {
            LOG.error("TXT\u89e3\u6790\u6240\u6709\u7684\u884c\u5931\u8d25", (Throwable)ex);
        }
    }
}

