/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.cgd.base.mq.MqConstants;
import com.cgd.base.mq.MqCunsumer;
import com.cgd.base.mq.MqCunsumerSubscribe;
import com.cgd.base.util.SerializeUtils;
import com.cgd.common.bo.MessageInfoBO;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusinessException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMqListener
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(NativeMqListener.class);
    private static Map<String, MqCunsumer> nativeTopics = null;
    private CacheService cacheService;

    public NativeMqListener(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    private static void setNativeTopics(Map<String, MqCunsumer> nativeTopics) {
        NativeMqListener.nativeTopics = nativeTopics;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.doBusi();
            }
            catch (Exception e) {
                log.error("\u672c\u5730\u6d88\u8d39\u8005\u6a21\u5f0f\u4e0b\u51fa\u73b0\u5f02\u5e38\u4e86\uff01\u8bf7\u68c0\u67e5\u9519\u8bef\uff01", (Throwable)e);
            }
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("\u7ebf\u7a0bsleep\u5f02\u5e38\uff01", (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void doBusi() {
        Set<String> keys = this.cacheService.getkeys("LOCALMQ_*");
        for (String key : keys) {
            MqCunsumer mqc;
            MessageInfoBO msgbo = this.cacheService.get(key, MessageInfoBO.class);
            if (msgbo == null || msgbo.getConsumerStatus() != null) continue;
            msgbo.setConsumerStatus(MqConstants.CONSUMER_STATUS_UPDATE);
            this.cacheService.put(key, msgbo);
            String topic = msgbo.getTopic();
            if (nativeTopics == null) {
                NativeMqListener.setNativeTopics(MqCunsumerSubscribe.nativeTopics);
            }
            if ((mqc = nativeTopics.get(topic)) == null) {
                msgbo.setConsumerStatus(null);
                this.cacheService.put(key, msgbo);
                continue;
            }
            this.executeMqc(key, mqc, msgbo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMqc(String key, MqCunsumer mqc, MessageInfoBO msgbo) {
        try {
            mqc.execute(msgbo.getTag(), SerializeUtils.deserialize(msgbo.getBody()));
        }
        catch (BusinessException e) {
            log.error("\u4e1a\u52a1\u6267\u884c\u5931\u8d25\uff01\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u9519\u8bef", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u5f02\u5e38!\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u9519\u8bef", (Throwable)e);
        }
        finally {
            this.cacheService.delete(key);
        }
    }
}

