/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static Object deserialize(byte[] bytes) {
        Object result = null;
        if (SerializeUtils.isEmpty(bytes)) {
            return null;
        }
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
             ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);){
            result = objectInputStream.readObject();
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize", (Throwable)e);
        }
        return result;
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static byte[] serialize(Object object) {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);){
            if (!(object instanceof Serializable)) {
                throw new IllegalArgumentException(SerializeUtils.class.getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
            }
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            result = byteStream.toByteArray();
        }
        catch (Exception ex) {
            LOG.error("Failed to serialize", (Throwable)ex);
        }
        return result;
    }
}

