/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.util;

import java.security.MessageDigest;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtil.class);
    private static final String TOKEN = "weixin";

    private SignUtil() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u80fd\u88ab\u5b9e\u4f8b\u5316");
    }

    public static boolean checkSignature(String signature, String timestamp, String nonce) {
        boolean result = false;
        Object[] array = new String[]{TOKEN, timestamp, nonce};
        Arrays.sort(array);
        String str = ((String)array[0]).concat((String)array[1]).concat((String)array[2]);
        String sha1Str = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(str.getBytes());
            sha1Str = SignUtil.byte2str(digest);
        }
        catch (Exception e) {
            LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-\u52a0\u5bc6]-\u5f02\u5e38", (Throwable)e);
        }
        if (sha1Str != null && sha1Str.equals(signature)) {
            result = true;
        }
        return result;
    }

    public static String byte2str(byte[] array) {
        StringBuilder hexstr = new StringBuilder();
        String shaHex = "";
        for (int i = 0; i < array.length; ++i) {
            shaHex = Integer.toHexString(array[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(shaHex);
        }
        return hexstr.toString();
    }
}

