/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.feature.orm.mybatis;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.JdbcConstants;
import com.cgd.feature.orm.dialect.Dialect;
import com.cgd.feature.orm.dialect.DialectFactory;
import com.cgd.feature.orm.mybatis.EncryTable;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.feature.orm.mybatis.PaginationStatementHandlerInterceptor;
import com.cgd.feature.orm.mybatis.ResultSetHandlerInterceptor;
import com.cgd.feature.orm.mybatis.enchance.AesUtils;
import com.cgd.feature.orm.mybatis.enchance.EnhanceColumn;
import com.cgd.feature.orm.mybatis.sql.NewMysqlSchemaStatVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="parameterize", args={Statement.class})})
public class StatementInterceptor
implements Interceptor,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaginationStatementHandlerInterceptor.class);
    public static final boolean IS_DEBUG = LOGGER.isDebugEnabled();
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private static final List<String> interceptorMapping = new LinkedList<String>();
    public static final String INDEX = "], index [";
    public static final String PARAMETER_OBJECT = "parameterObject";
    private final Map<String, List<String>> tableColumnMapping = new HashMap<String, List<String>>();
    private static final List<String> interceptorTable = new LinkedList<String>();
    private DataSource dataSource;

    public void afterPropertiesSet() throws Exception {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            List<EncryTable> columns = this.getEncryTableList(stmt);
            for (EncryTable table : columns) {
                if (table.getIsWild() == 1) {
                    try (ResultSet rs = stmt.executeQuery("show columns from " + table.gettName());){
                        ArrayList<String> columnList = new ArrayList<String>();
                        this.tableColumnMapping.put(table.gettName(), columnList);
                        while (rs.next()) {
                            columnList.add(rs.getString(1));
                        }
                    }
                }
                interceptorTable.add(table.gettName());
                for (String str : table.gettColumns()) {
                    interceptorMapping.add(table.gettName() + ":" + str);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u52a0\u5bc6\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    private List<EncryTable> getEncryTableList(Statement stmt) throws SQLException {
        ArrayList<EncryTable> columns = new ArrayList<EncryTable>();
        try (ResultSet rs = stmt.executeQuery("select t_name,t_columns,is_wild from t_encry_table");){
            while (rs.next()) {
                EncryTable encryTable = new EncryTable();
                encryTable.settName(rs.getString(1));
                String tColumn = rs.getString(2);
                String[] str = tColumn.split(",");
                ArrayList<String> columnList = new ArrayList<String>(Arrays.asList(str));
                encryTable.settColumns(columnList);
                encryTable.setIsWild(rs.getInt(3));
                columns.add(encryTable);
            }
        }
        return columns;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler && "parameterize".equals(invocation.getMethod().getName())) {
            return this.statmentProcess(invocation);
        }
        if (target instanceof StatementHandler && "prepare".equals(invocation.getMethod().getName())) {
            return this.pageination(target, invocation);
        }
        return invocation.proceed();
    }

    private Object pageination(Object target, Invocation invocation) throws Exception {
        StatementHandler statementHandler = (StatementHandler)target;
        ParameterHandler parameterHandler = statementHandler.getParameterHandler();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
        RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
        if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        Configuration configuration = (Configuration)metaStatementHandler.getValue("delegate.configuration");
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        Dialect dialect = DialectFactory.buildDialect(configuration);
        String originalSql = (String)metaStatementHandler.getValue("delegate.boundSql.sql");
        Page page = (Page)rowBounds;
        int offset = page.getOffset();
        int limit = page.getLimit();
        if (-1 < offset && -1 < limit) {
            PaginationStatementHandlerInterceptor ins = new PaginationStatementHandlerInterceptor();
            String countSql = ins.getCount(mappedStatement, parameterHandler);
            if (countSql == null) {
                countSql = dialect.getCountString(originalSql);
            }
            Connection connection = (Connection)invocation.getArgs()[0];
            StringBuilder debug = new StringBuilder();
            MetaObject paramHandlerMetaObject = MetaObject.forObject((Object)parameterHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
            Object paramObject = paramHandlerMetaObject.getValue(PARAMETER_OBJECT);
            MetaObject param = MetaObject.forObject((Object)paramObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
            List<EnhanceColumn> paramList = this.statmentObject(statementHandler, paramObject, paramHandlerMetaObject, param, debug);
            int total = ins.getTotal(parameterHandler, connection, countSql);
            if (!CollectionUtils.isEmpty(paramList)) {
                this.decodeInputParams(debug, paramList, paramHandlerMetaObject, paramObject, param);
            }
            page.setTotalCount(total);
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)dialect.getLimitString(originalSql, page.getOffset(), page.getLimit()));
        }
        metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
        metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5206\u9875SQL : {}", (Object)boundSql.getSql());
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object statmentProcess(Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        StringBuilder debug = new StringBuilder();
        try {
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            ParameterHandler parameterHandler = statementHandler.getParameterHandler();
            MetaObject paramHandlerMetaObject = MetaObject.forObject((Object)parameterHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
            Object paramObject = paramHandlerMetaObject.getValue(PARAMETER_OBJECT);
            MetaObject param = MetaObject.forObject((Object)paramObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
            List<EnhanceColumn> paramList = this.statmentObject(statementHandler, paramObject, paramHandlerMetaObject, param, debug);
            Object result = invocation.proceed();
            if (!CollectionUtils.isEmpty(paramList)) {
                this.decodeInputParams(debug, paramList, paramHandlerMetaObject, paramObject, param);
            }
            Object object = result;
            return object;
        }
        finally {
            LOGGER.debug("statmentProcess end");
        }
    }

    private List<EnhanceColumn> statmentObject(StatementHandler statementHandler, Object paramObject, MetaObject paramHandlerMetaObject, MetaObject param, StringBuilder debug) throws InvocationTargetException, IllegalAccessException {
        boolean isUpdateSql;
        List parameterMappingList = statementHandler.getBoundSql().getParameterMappings();
        String originSQL = statementHandler.getBoundSql().getSql();
        MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
        String dbType = JdbcConstants.MYSQL.name();
        List stmtList = SQLUtils.parseStatements((String)originSQL, (String)dbType, (SQLParserFeature[])new SQLParserFeature[]{SQLParserFeature.KeepNameQuotes});
        ArrayList<EnhanceColumn> paramColumnList = new ArrayList<EnhanceColumn>();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (stmtList.size() != 1) {
            return paramColumnList;
        }
        SQLStatement sqlstmt = (SQLStatement)stmtList.get(0);
        if (IS_DEBUG) {
            debug.append("\n/**\n").append(" * execute sql \n").append(" **/\n");
            debug.append(sqlstmt.toLowerCaseString()).append("\n");
            debug.append("paramMapping:[");
            for (ParameterMapping paramMapping : parameterMappingList) {
                debug.append("\n\t{name:").append(paramMapping.getProperty()).append(",mode:").append(paramMapping.getMode()).append("}");
            }
            debug.append("\n]\n");
        }
        boolean isSelectSql = (isUpdateSql = MySqlUpdateStatement.class.isInstance(sqlstmt)) ? false : SQLSelectStatement.class.isInstance(sqlstmt);
        boolean isInsertSql = isUpdateSql || isSelectSql ? false : MySqlInsertStatement.class.isInstance(sqlstmt);
        NewMysqlSchemaStatVisitor visitor = new NewMysqlSchemaStatVisitor();
        sqlstmt.accept((SQLASTVisitor)visitor);
        Map<TableStat.Name, TableStat> tables = visitor.getTables();
        ArrayList resTableList = new ArrayList();
        for (Map.Entry<TableStat.Name, TableStat> nameTableStatEntry : tables.entrySet()) {
            interceptorTable.stream().forEach(e -> {
                if (e.equalsIgnoreCase(((TableStat.Name)nameTableStatEntry.getKey()).getName())) {
                    resTableList.add(((TableStat.Name)nameTableStatEntry.getKey()).getName());
                }
            });
        }
        if (CollectionUtils.isEmpty(resTableList)) {
            return paramColumnList;
        }
        boolean isDeleteSql = SqlCommandType.DELETE == sqlCommandType;
        List<EnhanceColumn> paramList = this.fetchParams(sqlstmt, parameterMappingList, visitor, debug, new Boolean[]{isSelectSql, isInsertSql, isUpdateSql, isDeleteSql});
        param = MetaObject.forObject((Object)paramObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
        if (IS_DEBUG) {
            debug.append("paramColumnList:[\n");
            for (EnhanceColumn paramColumn : paramColumnList) {
                debug.append("\t{table:").append(paramColumn.getTable()).append(",column:").append(paramColumn.getColumn()).append(",enchance:").append(paramColumn.isNeedEncode()).append("}\n");
            }
            debug.append("]\n");
        }
        this.encodeInputParams(debug, paramList, paramHandlerMetaObject, paramObject, param);
        this.extractAndEnhanceSelectItems(sqlstmt, debug, mappedStatement, isSelectSql, visitor.getColumns().iterator());
        return paramList;
    }

    private void decodeInputParams(StringBuilder debug, List<EnhanceColumn> paramList, MetaObject paramHandlerMetaObject, Object paramObject, MetaObject param) {
        for (int i = 0; i < paramList.size(); ++i) {
            boolean isPrimitiveProcess;
            EnhanceColumn enhanceColumn = paramList.get(i);
            if (!enhanceColumn.isNeedEncode()) continue;
            Class<?> javaType = enhanceColumn.getPropertyType();
            if (IS_DEBUG) {
                debug.append("extract javaType: param[").append(enhanceColumn.getFullName()).append("], javaType[").append(javaType.getClass().getName()).append("\n");
            }
            if (!(isPrimitiveProcess = javaType.isPrimitive()) && paramObject != null) {
                boolean bl = isPrimitiveProcess = paramObject.getClass().isPrimitive() || paramObject.getClass() == String.class;
            }
            if (isPrimitiveProcess) continue;
            Object ecolValue = isPrimitiveProcess ? paramObject : param.getValue(enhanceColumn.getProperty());
            Object originValue = ecolValue;
            if (!StringUtils.isEmpty((Object)ecolValue)) {
                ecolValue = AesUtils.decrypt(ecolValue.toString(), AesUtils.getPrivateKey(null));
                param.setValue(enhanceColumn.getProperty(), ecolValue);
            }
            if (!IS_DEBUG) continue;
            debug.append("param[").append(enhanceColumn.getColumn()).append("], originValue[").append(originValue);
            debug.append("], decode value[").append(ecolValue).append("], class[").append(javaType.getName()).append("], isPrimitive[").append(isPrimitiveProcess).append("]\n");
        }
    }

    private void encodeInputParams(StringBuilder debug, List<EnhanceColumn> paramList, MetaObject paramHandlerMetaObject, Object paramObject, MetaObject param) {
        for (int i = 0; i < paramList.size(); ++i) {
            boolean isPrimitiveProcess;
            EnhanceColumn enhanceColumn = paramList.get(i);
            if (!enhanceColumn.isNeedEncode()) continue;
            Class<?> javaType = enhanceColumn.getPropertyType();
            if (IS_DEBUG) {
                debug.append("extract javaType: param[").append(enhanceColumn.getFullName()).append("], javaType[").append(javaType.getClass().getName()).append("\n");
            }
            if (!(isPrimitiveProcess = javaType.isPrimitive()) && paramObject != null) {
                isPrimitiveProcess = paramObject.getClass().isPrimitive() || paramObject.getClass() == String.class;
            }
            Object ecolValue = isPrimitiveProcess ? paramObject : param.getValue(enhanceColumn.getProperty());
            Object originValue = ecolValue;
            if (!StringUtils.isEmpty((Object)ecolValue)) {
                if (isPrimitiveProcess) {
                    ecolValue = AesUtils.encrypt(ecolValue.toString(), AesUtils.getPrivateKey(null));
                    paramHandlerMetaObject.setValue(PARAMETER_OBJECT, ecolValue);
                } else {
                    ecolValue = AesUtils.encrypt(ecolValue.toString(), AesUtils.getPrivateKey(null));
                    param.setValue(enhanceColumn.getProperty(), ecolValue);
                }
            }
            if (!IS_DEBUG) continue;
            debug.append("param[").append(enhanceColumn.getColumn()).append("], originValue[").append(originValue);
            debug.append("], encode value[").append(ecolValue).append("], class[").append(javaType.getName()).append("], isPrimitive[").append(isPrimitiveProcess).append("]\n");
        }
    }

    private void extractAndEnhanceSelectItems(SQLStatement sqlstmt, StringBuilder debug, MappedStatement mappedStatement, boolean isSelectSql, Iterator<TableStat.Column> columnIter) {
        List<Object> columnAliasList;
        List<Object> list = columnAliasList = isSelectSql ? this.extractColumnAliasList(sqlstmt) : new ArrayList();
        if (isSelectSql) {
            int columnAliasOffset = 0;
            boolean camelCase = mappedStatement.getConfiguration().isMapUnderscoreToCamelCase();
            boolean mapOrType = true;
            if (((ResultMap)mappedStatement.getResultMaps().get(0)).getResultMappings().isEmpty()) {
                mapOrType = false;
            }
            HashSet<String> validColumnSet = new HashSet<String>();
            ArrayList<EnhanceColumn> alisaList = new ArrayList<EnhanceColumn>();
            for (SQLSelectItem sQLSelectItem : columnAliasList) {
                SQLExprTableSource exprTableSource;
                SQLSubqueryTableSource ex;
                SQLTableSource sqlTableSource;
                EnhanceColumn asliasColumn = new EnhanceColumn();
                asliasColumn.setAlias(sQLSelectItem.getAlias());
                String columnName = null;
                SQLExpr expr = sQLSelectItem.getExpr();
                if (expr instanceof SQLIdentifierExpr) {
                    columnName = ((SQLIdentifierExpr)expr).getName();
                    sqlTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
                    if (sqlTableSource instanceof SQLSubqueryTableSource) {
                        ex = (SQLSubqueryTableSource)sqlTableSource;
                        if (ex != null) {
                            continue;
                        }
                    } else {
                        exprTableSource = (SQLExprTableSource)sqlTableSource;
                        if (exprTableSource != null) {
                            asliasColumn.setTable(exprTableSource.getTableName(true));
                            asliasColumn.setColumn(SQLUtils.normalize((String)columnName));
                        }
                    }
                } else if (expr instanceof SQLPropertyExpr) {
                    columnName = ((SQLPropertyExpr)expr).getName();
                    sqlTableSource = ((SQLPropertyExpr)expr).getResolvedTableSource();
                    if (sqlTableSource instanceof SQLSubqueryTableSource) {
                        ex = (SQLSubqueryTableSource)sqlTableSource;
                        if (ex != null) {
                            continue;
                        }
                    } else {
                        exprTableSource = (SQLExprTableSource)((SQLPropertyExpr)expr).getResolvedTableSource();
                        if (exprTableSource != null) {
                            asliasColumn.setTable(exprTableSource.getTableName(true));
                            asliasColumn.setColumn(SQLUtils.normalize((String)columnName));
                        }
                    }
                }
                alisaList.add(asliasColumn);
                validColumnSet.add(SQLUtils.normalize((String)columnName));
            }
            if (IS_DEBUG) {
                debug.append("validColumnSet:").append(validColumnSet).append("\n");
            }
            TreeMap<String, EnhanceColumn> selectColumnMapping = new TreeMap<String, EnhanceColumn>(String.CASE_INSENSITIVE_ORDER);
            while (columnIter.hasNext()) {
                List<String> tcolumns;
                TableStat.Column column = columnIter.next();
                String key = column.getTable() + ":" + column.getName();
                if (!column.isSelect() || columnAliasOffset >= columnAliasList.size()) continue;
                if (column.getName().equals("*") && !CollectionUtils.isEmpty(tcolumns = this.tableColumnMapping.get(column.getTable()))) {
                    for (String tcolumn : tcolumns) {
                        EnhanceColumn ecolumn = new EnhanceColumn();
                        ecolumn.setTable(column.getTable());
                        ecolumn.setColumn(tcolumn);
                        key = ecolumn.uniqueKey();
                        ecolumn.setNeedEncode(interceptorMapping.stream().anyMatch(key::equalsIgnoreCase));
                        selectColumnMapping.put(ecolumn.getColumn(), ecolumn);
                        if (mapOrType) continue;
                        if (camelCase) {
                            tcolumn = tcolumn.replace("_", "");
                        }
                        ecolumn.setWildCard(true);
                        selectColumnMapping.put(tcolumn.toUpperCase(Locale.ENGLISH), ecolumn);
                    }
                    continue;
                }
                if (!validColumnSet.contains(column.getName())) continue;
                EnhanceColumn ecolumn = new EnhanceColumn();
                ecolumn.setTable(column.getTable());
                alisaList.forEach(e -> {
                    if (e.getTable() != null && e.getTable().equalsIgnoreCase(sqlColumn.getTable()) && e.getColumn().equalsIgnoreCase(sqlColumn.getName())) {
                        ecolumn.setAlias(e.getAlias());
                    }
                });
                ecolumn.setColumn(column.getName());
                ecolumn.setNeedEncode(interceptorMapping.stream().anyMatch(key::equalsIgnoreCase));
                selectColumnMapping.put(ecolumn.getColumn(), ecolumn);
                if (ecolumn.getAlias() == null) continue;
                String alias = ecolumn.getAlias();
                if (camelCase) {
                    alias = alias.replace("_", "");
                }
                selectColumnMapping.put(alias, ecolumn);
            }
            List list2 = mappedStatement.getResultMaps();
            if (list2 != null && !list2.isEmpty()) {
                for (ResultMap resultMap : list2) {
                    List resultMappingList = resultMap.getResultMappings();
                    if (resultMappingList.isEmpty()) {
                        Class resultType = resultMap.getType();
                        if (resultType == null) {
                            throw new UnsupportedOperationException("\u672a\u786e\u8ba4[" + mappedStatement.getId() + "] \u67e5\u8be2\u7ed3\u679c\u7684\u7c7b\u578b\uff01" + sqlstmt.toString());
                        }
                        List<Field> fieldList = this.getAllFied(resultType);
                        for (Field field : fieldList) {
                            String resultJavaProperty = field.getName();
                            EnhanceColumn column = (EnhanceColumn)selectColumnMapping.get(resultJavaProperty);
                            if (column == null && ((column = (EnhanceColumn)selectColumnMapping.get(resultJavaProperty.toUpperCase(Locale.ENGLISH))) == null || !column.getWildCard().booleanValue())) continue;
                            column.setProperty(resultJavaProperty);
                        }
                        continue;
                    }
                    for (ResultMapping resultMapping : resultMappingList) {
                        if (!StringUtils.isEmpty((Object)resultMapping.getNestedResultMapId())) {
                            try {
                                ResultMap resultMap1 = mappedStatement.getConfiguration().getResultMap(resultMapping.getNestedResultMapId());
                                List resultMappingList1 = resultMap1.getResultMappings();
                                for (ResultMapping resultMapping1 : resultMappingList1) {
                                    EnhanceColumn column = (EnhanceColumn)selectColumnMapping.get(resultMapping1.getColumn());
                                    if (column == null) continue;
                                    column.setProperty(resultMapping1.getProperty());
                                    column.setParentProperty(resultMapping.getProperty());
                                    column.setParentPropertyType(resultMapping.getJavaType());
                                }
                                continue;
                            }
                            catch (IllegalArgumentException ex) {
                                continue;
                            }
                        }
                        EnhanceColumn column = (EnhanceColumn)selectColumnMapping.get(resultMapping.getColumn());
                        if (column == null) continue;
                        column.setProperty(resultMapping.getProperty());
                    }
                }
            } else {
                throw new UnsupportedOperationException("\u672a\u91c7\u96c6[" + mappedStatement.getId() + "] \u67e5\u8be2\u7ed3\u679c\u7684\u7c7b\u578b\uff01" + sqlstmt.toString());
            }
            ResultSetHandlerInterceptor.setSelectColumnMapping(selectColumnMapping);
        }
    }

    private List<Field> getAllFied(Class<?> resultType) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int k = 0;
        while (resultType != null) {
            fieldList.addAll(Arrays.asList(resultType.getDeclaredFields()));
            resultType = resultType.getSuperclass();
            if (++k <= 4) continue;
            break;
        }
        return fieldList;
    }

    private List<SQLSelectItem> extractColumnAliasList(SQLStatement sqlstmt) {
        SQLTableSource sqlTableSource;
        SQLSelectQuery sqlSelectQuery = ((SQLSelectStatement)sqlstmt).getSelect().getQuery();
        if (SQLUnionQuery.class.isInstance(sqlSelectQuery)) {
            sqlSelectQuery = ((SQLUnionQuery)sqlSelectQuery).getLeft();
        }
        if (SQLSubqueryTableSource.class.isInstance(sqlTableSource = ((MySqlSelectQueryBlock)sqlSelectQuery).getFrom()) && SQLUnionQuery.class.isInstance(sqlSelectQuery = ((SQLSubqueryTableSource)sqlTableSource).getSelect().getQuery())) {
            sqlSelectQuery = ((SQLUnionQuery)sqlSelectQuery).getLeft();
        }
        return ((MySqlSelectQueryBlock)sqlSelectQuery).getSelectList();
    }

    private List<EnhanceColumn> fetchParams(SQLStatement stmt, List<ParameterMapping> parameterMappingList, NewMysqlSchemaStatVisitor visitor, StringBuilder debug, Boolean[] sqlTypes) {
        boolean isInsertSQL = sqlTypes[1];
        boolean isUpdateSQL = sqlTypes[2];
        ArrayList<EnhanceColumn> paramColumnList = new ArrayList<EnhanceColumn>();
        if (isUpdateSQL) {
            List updateItemList = ((MySqlUpdateStatement)stmt).getItems();
            for (int i = 0; i < updateItemList.size(); ++i) {
                SQLUpdateSetItem setItem = (SQLUpdateSetItem)updateItemList.get(i);
                String value = setItem.getValue().toString();
                if (!value.equals("?")) continue;
                EnhanceColumn column = new EnhanceColumn();
                column.setColumn(setItem.getColumn().toString());
                column.setTable(((MySqlUpdateStatement)stmt).getTableName().getSimpleName());
                column.setNeedEncode(interceptorMapping.stream().anyMatch((column.getTable() + ":" + column.getColumn())::equalsIgnoreCase));
                column.setParamIndex(paramColumnList.size());
                ParameterMapping pm = parameterMappingList.get(column.getParamIndex());
                column.setProperty(pm.getProperty());
                column.setPropertyType(pm.getJavaType());
                paramColumnList.add(column);
            }
        } else if (isInsertSQL) {
            List insertColumns = ((MySqlInsertStatement)stmt).getColumns();
            List valuesClauseList = ((MySqlInsertStatement)stmt).getValuesList();
            for (int k = 0; k < valuesClauseList.size(); ++k) {
                SQLInsertStatement.ValuesClause valuesClause = (SQLInsertStatement.ValuesClause)valuesClauseList.get(k);
                List insertValues = valuesClause.getValues();
                for (int i = 0; i < insertColumns.size(); ++i) {
                    SQLExpr insertValue = (SQLExpr)insertValues.get(i);
                    if (!insertValue.toString().equals("?")) continue;
                    SQLIdentifierExpr insertColumn = (SQLIdentifierExpr)insertColumns.get(i);
                    EnhanceColumn column = new EnhanceColumn();
                    column.setColumn(insertColumn.getName());
                    column.setTable(((MySqlInsertStatement)stmt).getTableName().getSimpleName());
                    column.setValue(insertValue.toString());
                    column.setNeedEncode(interceptorMapping.stream().anyMatch((column.getTable() + ":" + column.getColumn())::equalsIgnoreCase));
                    column.setParamIndex(paramColumnList.size());
                    ParameterMapping pm = parameterMappingList.get(column.getParamIndex());
                    if (pm.getProperty().indexOf("__frch_item_") > -1) {
                        String property = "list[" + pm.getProperty().substring("__frch_item_".length(), pm.getProperty().lastIndexOf(".")) + "]";
                        if (pm.getProperty().indexOf(".") > -1) {
                            property = property + "." + pm.getProperty().substring(pm.getProperty().lastIndexOf(".") + 1);
                        }
                        column.setProperty(property);
                    } else {
                        column.setProperty(pm.getProperty());
                    }
                    column.setPropertyType(pm.getJavaType());
                    paramColumnList.add(column);
                }
            }
        }
        if (IS_DEBUG) {
            debug.append("-----------paramColumnList------------>").append(paramColumnList).append("\n");
        }
        List<TableStat.Condition> conditionList = visitor.getConditions();
        ArrayList<TableStat.Condition> filterdConditionList = new ArrayList<TableStat.Condition>();
        boolean skip = false;
        block3: for (int i = 0; i < conditionList.size(); ++i) {
            TableStat.Condition sqlCondition = conditionList.get(i);
            if (IS_DEBUG) {
                debug.append("----extract condition[").append(sqlCondition.getColumn().getFullName()).append(INDEX).append(i).append("],  value ").append(sqlCondition.getValues().toString()).append("\n");
            }
            if (skip) {
                if (IS_DEBUG) {
                    debug.append("2sed skip condition[").append(sqlCondition.getColumn().getFullName()).append(INDEX).append(i).append("], value is ").append(sqlCondition.getValues()).append("\n");
                }
                skip = false;
                if (!sqlCondition.getValues().isEmpty()) {
                    debug.append("this condition is not on");
                } else {
                    TableStat.Condition preCondition = conditionList.get(i - 1);
                    if (!preCondition.getOperator().equals(sqlCondition.getOperator()) || !sqlCondition.getValues().isEmpty() || preCondition.getColumn().getFullName().equals(sqlCondition.getColumn().getFullName())) continue;
                    filterdConditionList.add(preCondition);
                    continue;
                }
            }
            if (sqlCondition.getColumn().isJoin() && sqlCondition.getValues().isEmpty()) continue;
            if (sqlCondition.getValues().isEmpty()) {
                if (IS_DEBUG) {
                    debug.append("1st skip condition[").append(sqlCondition.getColumn().getFullName()).append(INDEX).append(i).append("], value is empty.\n");
                }
                skip = true;
                continue;
            }
            if (IS_DEBUG) {
                debug.append("extract condition[").append(sqlCondition.getColumn().getFullName()).append(INDEX).append(i).append("],  value ").append(sqlCondition.getValues().toString()).append("\n");
            }
            for (Object value : sqlCondition.getValues()) {
                if (value == null) {
                    if (sqlCondition.getOperator().equalsIgnoreCase("in") || sqlCondition.getOperator().equalsIgnoreCase("not in")) {
                        filterdConditionList.add(sqlCondition);
                        continue block3;
                    }
                    if (sqlCondition.getOperator().equalsIgnoreCase("is") || sqlCondition.getOperator().equalsIgnoreCase("is not")) continue;
                    filterdConditionList.add(sqlCondition);
                    continue;
                }
                if (value.toString().contains("?")) {
                    filterdConditionList.add(sqlCondition);
                    continue block3;
                }
                if (!IS_DEBUG) continue block3;
                debug.append("ignore condition[").append(sqlCondition.getColumn().getFullName()).append(INDEX).append(i).append("], value [").append(value).append("]\n");
                continue block3;
            }
        }
        for (TableStat.Condition sqlCondition : filterdConditionList) {
            for (Object value : sqlCondition.getValues()) {
                if (value != null && !value.toString().contains("?")) continue;
                EnhanceColumn column = new EnhanceColumn();
                column.setColumn(sqlCondition.getColumn().getName());
                column.setTable(sqlCondition.getColumn().getTable());
                column.setValue(value == null ? null : value.toString());
                column.setNeedEncode(interceptorMapping.stream().anyMatch((column.getTable() + ":" + column.getColumn())::equalsIgnoreCase));
                column.setParamIndex(paramColumnList.size());
                column.setCondition(true);
                ParameterMapping pm = parameterMappingList.get(column.getParamIndex());
                column.setProperty(pm.getProperty());
                column.setPropertyType(pm.getJavaType());
                paramColumnList.add(column);
            }
        }
        if (IS_DEBUG) {
            for (EnhanceColumn param : paramColumnList) {
                param.setNeedEncode(interceptorMapping.stream().anyMatch((param.getTable() + ":" + param.getColumn())::equalsIgnoreCase));
                debug.append("enhance param[").append(param.getFullName()).append("]").append(", property[").append(param.getProperty()).append("], isCondition[").append(param.isCondition()).append("]").append(", javaType[").append(param.getPropertyType().getName()).append("], needEncode[").append(param.isNeedEncode()).append("]\n");
            }
        }
        return paramColumnList;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        LOGGER.debug("PROP IS EMPTY");
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

