/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.cgd.base.util.LogUtils;
import com.cgd.common.exception.BusinessException;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.Ordered;

public class AtomServiceAopAdvisor
implements Ordered {
    public int getOrder() {
        return 100;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        Map hiddenParm = RpcContext.getContext().getAttachments();
        String traceId = "";
        if (hiddenParm.containsKey("traceId")) {
            traceId = (String)hiddenParm.get("traceId");
        } else {
            hiddenParm.put("traceId", traceId);
        }
        String[] infos = LogUtils.printAtomServiceAopStartLog(pjp, traceId);
        Object returnObj = null;
        try {
            returnObj = pjp.proceed();
        }
        catch (BusinessException e) {
            LogUtils.printAtomAopErrorLog(infos, e);
            throw e;
        }
        catch (Throwable e) {
            LogUtils.printAtomAopErrorLog(infos, e);
            throw e;
        }
        LogUtils.printAtomServiceAopEndLog(infos);
        return returnObj;
    }
}

