/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.cgd.base.util.LogUtils;
import com.cgd.common.annotation.BusiRequest;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.cache.service.CacheExecuterService;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.intfce.bo.RspIntfceBaseBO;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class IntfceAopAdvisor
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(IntfceAopAdvisor.class);
    public static final String OUTER_CODE = "outerCode";
    public static final String RESP_CODE = "respCode";
    public static final String RESP_DESC = "respDesc";
    private final boolean isDebugEnabled = LOG.isDebugEnabled();
    private CacheExecuterService<Map<String, String>> exceptionInfoService;
    private CacheService cacheService;

    public int getOrder() {
        return 0;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        RpcContext rpcContext = RpcContext.getContext();
        Map hiddenParm = rpcContext.getAttachments();
        String traceId = "";
        if (hiddenParm.containsKey("traceId")) {
            traceId = (String)hiddenParm.get("traceId");
        } else {
            hiddenParm.put("traceId", traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        String[] infos = LogUtils.printAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            msgCode = this.getMsgCode(e, msgCode);
            LogUtils.printAopErrorLog(infos, null, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            LOG.error("\u7cfb\u7edf\u5f02\u5e38  ", e);
            rspObj = rspClass.newInstance();
            LogUtils.printAopErrorLog(infos, null, e);
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25");
        }
        LogUtils.printAopEndLog(infos);
        return rspObj;
    }

    private String getMsgCode(BusinessException e, String msgCode) {
        if (msgCode != null && !"".equals(msgCode)) {
            Map<String, String> outerCodeMap = this.cacheService.getOuterCodeByKey(this.exceptionInfoService, msgCode);
            String string = msgCode = outerCodeMap.get(OUTER_CODE) == null ? e.getMsgCode() : outerCodeMap.get(OUTER_CODE);
        }
        if (msgCode == null || "".equals(msgCode)) {
            if (e.getCause() instanceof BusinessException) {
                msgCode = e.getMsgCode();
            }
            if (msgCode == null || "".equals(msgCode)) {
                msgCode = "8888";
            }
        }
        return msgCode;
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        LOG.debug("fource:{}", (Object)fource);
        if (object instanceof RspIntfceBaseBO) {
            field = RspIntfceBaseBO.class.getDeclaredField(RESP_CODE);
            field.setAccessible(true);
            if (field.get(object) == null) {
                this.fieldRspIntfceBaseBO(object, code, desc, field);
            }
        }
        if (object instanceof RspInfoBO) {
            field = RspInfoBO.class.getDeclaredField(RESP_CODE);
            field.setAccessible(true);
            if (field.get(object) == null) {
                this.feildRspInfoBOSet(object, code, desc, field);
            }
        }
    }

    private void feildRspInfoBOSet(Object object, String code, String desc, Field field) throws IllegalAccessException, NoSuchFieldException {
        field.set(object, code);
        field = RspInfoBO.class.getDeclaredField(RESP_DESC);
        field.setAccessible(true);
        field.set(object, desc);
    }

    private void fieldRspIntfceBaseBO(Object object, String code, String desc, Field field) throws IllegalAccessException, NoSuchFieldException {
        field.set(object, code);
        field = RspIntfceBaseBO.class.getDeclaredField(RESP_DESC);
        field.setAccessible(true);
        field.set(object, desc);
    }

    public Object bulidRspObj(BusiRequest br, Class<?> resClass) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        Object rspObj = null;
        String key = br.key();
        String desc = br.desc();
        Map<String, String> outerCodeMap = this.cacheService.getOuterCodeByKey(this.exceptionInfoService, key);
        if (this.isDebugEnabled) {
            LOG.debug("\u5916\u90e8\u7f16\u7801outerCode={},\u5916\u90e8\u7f16\u7801\u63cf\u8ff0outerCodeDesc={}", (Object)outerCodeMap.get(OUTER_CODE), (Object)outerCodeMap.get("outerCodeDesc"));
        }
        key = outerCodeMap.get(OUTER_CODE) == null ? key : outerCodeMap.get(OUTER_CODE);
        rspObj = resClass.newInstance();
        this.putCodeToRsp(rspObj, key, desc);
        return rspObj;
    }

    public void put(String key, String value, Map<String, String> hiddenParm) {
        hiddenParm.computeIfAbsent(key, k -> value);
    }

    public void setExceptionInfoService(CacheExecuterService<Map<String, String>> exceptionInfoService) {
        this.exceptionInfoService = exceptionInfoService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

