/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.dict.util;

import com.cgd.common.exception.BusinessException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationUtils.class);
    private static final Properties PROPS = new Properties();
    private static final Integer MAX_IP_COUNT = 15;

    private ApplicationUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static final String getEnvProp(String name) {
        return PROPS.getProperty(name);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String md5Hex(String value) {
        return DigestUtils.md5Hex((String)value);
    }

    public static String sha1Hex(String value) {
        return DigestUtils.sha1Hex((String)value);
    }

    public static String sha256Hex(String value) {
        return DigestUtils.sha256Hex((String)value);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ApplicationUtils.validateIpAddressNull(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ApplicationUtils.validateIpAddressNull(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ApplicationUtils.validateIpAddressNull(ipAddress) && (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            ipAddress = ApplicationUtils.getLocalHostIPAddress(ipAddress);
        }
        if (ipAddress != null && ApplicationUtils.validAddress(ipAddress)) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    private static boolean validAddress(String ipAddress) {
        return ipAddress.length() > MAX_IP_COUNT && ipAddress.indexOf(",") > MAX_IP_COUNT;
    }

    private static String getLocalHostIPAddress(String ipAddress) {
        InetAddress inet = null;
        try {
            inet = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.error("[\u57fa\u7840\u4e2d\u5fc3-\u5e94\u7528\u7a0b\u5e8f\u5de5\u5177\u7c7b]-\u6839\u636e\u7f51\u5361\u53d6\u672c\u673a\u914d\u7f6e\u7684IP\u5f02\u5e38|", (Throwable)e);
        }
        if (inet != null) {
            ipAddress = inet.getHostAddress();
        }
        return ipAddress;
    }

    private static boolean validateIpAddressNull(String ipAddress) {
        return ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress);
    }

    static {
        LOGGER.info("[\u57fa\u7840\u4e2d\u5fc3-\u5e94\u7528\u7a0b\u5e8f\u5de5\u5177\u7c7b]-\u52a0\u8f7d[env.properties]");
        String envFile = ApplicationUtils.class.getClassLoader().getResource("env.properties").getFile();
        try (FileInputStream ins = new FileInputStream(envFile);){
            PROPS.load(ins);
        }
        catch (FileNotFoundException e) {
            throw new BusinessException("8888", "\u6587\u4ef6[" + envFile + "\u4e0d\u5b58\u5728]", e);
        }
        catch (IOException e) {
            throw new BusinessException("8888", "\u8bfb\u53d6\u6587\u4ef6[" + envFile + "\u9519\u8bef]", e);
        }
        catch (RuntimeException t) {
            throw new BusinessException("8888", "\u52a0\u8f7d\u6587\u4ef6[" + envFile + "\u9519\u8bef]", t);
        }
    }
}

