/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.file;

import com.cgd.base.file.ftp.FtpConfig;
import com.cgd.base.file.ftp.FtpUtil;
import com.cgd.base.file.oss.OssConfig;
import com.cgd.base.file.oss.OssUtil;
import com.cgd.common.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(FileProcessing.class);
    public static final String URL_PATH_LINE = "/";
    private static Properties prop;
    private static String fileHost;
    private static String fileUser;
    private static String filePwd;
    private static Integer filePort;
    private static Integer timeOut;
    private static String sysFtpRootPath;
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String accessUrl;
    private static boolean nativeOSS;
    private static FtpConfig ftpConfig;
    private static OssConfig ossConfig;
    private static String esbFtpUpload;
    private static String esbFtpDowload;

    public synchronized void setProp(Properties prop) {
        FileProcessing.prop = prop;
        fileHost = FileProcessing.prop.getProperty("FILE_HOST").trim();
        fileUser = FileProcessing.prop.getProperty("FILE_USER").trim();
        filePwd = FileProcessing.prop.getProperty("FILE_PWD").trim();
        filePort = Integer.parseInt(FileProcessing.prop.getProperty("FILE_PORT").trim());
        timeOut = Integer.parseInt(FileProcessing.prop.getProperty("TIME_OUT").trim());
        sysFtpRootPath = FileProcessing.prop.getProperty("FILE_UPLOAD_PATH").trim();
        endpoint = FileProcessing.prop.getProperty("OSS_ENDPOINT").trim();
        accessKeyId = FileProcessing.prop.getProperty("OSS_ACCESSKEY").trim();
        accessKeySecret = FileProcessing.prop.getProperty("OSS_ACCESSKEY_SECRET").trim();
        nativeOSS = Boolean.parseBoolean(FileProcessing.prop.getProperty("OSS_NATIVE", "true"));
        bucketName = FileProcessing.prop.getProperty("OSS_BUCKETNAME").trim();
        accessUrl = FileProcessing.prop.getProperty("OSS_ACCESS_URL").trim();
        if (nativeOSS) {
            ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
        }
        ftpConfig = new FtpConfig(fileHost, fileUser, filePwd, filePort, timeOut);
        esbFtpUpload = FileProcessing.prop.getProperty("ESB_FTP_UPLOAD").trim();
        esbFtpDowload = FileProcessing.prop.getProperty("ESB_FTP_DOWLOAD").trim();
    }

    public static File downloadFile(String fileName, String sysCenter, String businessType) {
        File file = null;
        file = nativeOSS ? OssUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig) : FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
        return file;
    }

    public static File downloadFileNew(String name, String fileName, String sysCenter, String businessType) {
        File file = null;
        file = nativeOSS ? OssUtil.downloadFileNewName(name, FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig) : FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
        return file;
    }

    private static String getSysFileServicePath(String sysCenter, String businessType) {
        String filePath = null;
        LOG.debug("\u6587\u4ef6\u4e0a\u4f20\u4e1a\u52a1\u7c7b\u578b:{}", (Object)businessType);
        if ("CARD_CENTER".equals(sysCenter) || "NUM_CENTER".equals(sysCenter)) {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        } else {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
        }
        return filePath;
    }

    public static String upLoadFile(File file, String businessType, String sysCenter, boolean isNeedNewName) {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        } else {
            FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static String upLoadFileResponsePath(File file, String businessType, String sysCenter, boolean isNeedNewName) {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
            fileName = accessUrl + URL_PATH_LINE + sysFtpRootPath + fileName;
        } else {
            FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static void upLoadFileToEsb(File file) {
        FtpUtil.uploadFile(file, ftpConfig, esbFtpUpload);
    }

    public static File downLoadFileFromEsb(String fileName) {
        return FtpUtil.downloadFile(esbFtpDowload + fileName, ftpConfig);
    }

    public static List<String> listFiles(String suffix) {
        return FtpUtil.listFiles(esbFtpDowload, suffix, ftpConfig);
    }

    public static String uploadFileByInputStream(String fileName, InputStream inputStream, String businessType, String sysCenter, boolean isNeedNewName) {
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        try {
            if (nativeOSS) {
                OssUtil.uploadFileByInputStream(fileName, ossConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                fileName = accessUrl + URL_PATH_LINE + sysFtpRootPath + fileName;
            } else {
                FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("uploaded file path:{}", (Object)fileName);
            }
        }
        catch (BusinessException e) {
            LOG.error("\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
            throw new BusinessException("8888", "\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u51fa\u9519\uff01");
        }
        return fileName;
    }

    public static void mergeFile(File file, InputStream is) {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));){
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.flush();
        }
        catch (IOException e) {
            LOG.error("\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            throw new BusinessException("8888", "\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u9519\u8bef");
        }
    }

    public static void deleteFile(String fileName, String sysCenter, String businessType) {
        if (nativeOSS) {
            OssUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + URL_PATH_LINE + fileName, ossConfig);
        } else {
            FtpUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + URL_PATH_LINE + fileName, ftpConfig);
        }
    }

    public static BufferedInputStream getObject(String sysCenter, String businessType, String key) {
        return OssUtil.getObject(ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType) + key);
    }

    static {
        nativeOSS = false;
    }
}

