/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.ParserFactory;
import com.cgd.base.fileanalyzing.ParserRule;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public abstract class BaseXlsParser
extends ParserFactory {
    private DateFormat dayOfYear = new SimpleDateFormat("yyyy-MM-dd");
    private DecimalFormat decimalFormat = new DecimalFormat("#");
    protected static final int SHEET_INDEX = 0;

    protected BaseXlsParser(ParserRule parserRule) {
        super(parserRule);
    }

    protected String getStringCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue().trim();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return this.dayOfYear.format(cell.getDateCellValue()).trim();
                }
                return String.valueOf(this.decimalFormat.format(cell.getNumericCellValue())).trim();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue()).trim();
            }
            case 3: {
                return "";
            }
        }
        return "";
    }
}

