/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.fileanalyzing.BaseXlsParser;
import com.cgd.base.fileanalyzing.FileParserResult;
import com.cgd.base.fileanalyzing.ParserRule;
import com.cgd.common.exception.ResourceException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class IndexXlsParser
extends BaseXlsParser {
    public IndexXlsParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            Sheet sheet = WorkbookFactory.create((File)file).getSheetAt(0);
            int rowTotal = sheet.getLastRowNum();
            for (int i = this.parserRule.getLineIndex(); i <= rowTotal; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
                HashMap<String, String> map = new HashMap<String, String>();
                int columCount = row.getLastCellNum();
                for (int j = 0; j < columCount; ++j) {
                    String value = this.getStringCellValue(row.getCell(j));
                    map.put(indexToFieldNameRule.getString(String.valueOf(j)), value);
                }
                result.add(map);
            }
            fileParserResult.setTotal(rowTotal - this.parserRule.getLineIndex());
        }
        catch (Exception e) {
            throw new ResourceException("F003", "Excel\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u68c0\u67e5excel\u6587\u4ef6\u3010" + file.getName() + "\u3011\uff01", e);
        }
        fileParserResult.setData(result);
        return fileParserResult;
    }
}

