/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.FileParserResult;
import com.cgd.base.fileanalyzing.IndexTxtParser;
import com.cgd.base.fileanalyzing.IndexXlsParser;
import com.cgd.base.fileanalyzing.ParserRule;
import com.cgd.base.fileanalyzing.SimpleTxtParser;
import com.cgd.base.fileanalyzing.SimpleXlsParser;
import com.cgd.base.fileanalyzing.TitleTxtParser;
import com.cgd.base.fileanalyzing.TitleXlsParser;

public abstract class ParserFactory {
    public static final String FILE_TYPE_TXT = "txt";
    public static final String FILE_TYPE_XLS = "xls";
    public static final String ANALYZING_TYPE_SIMPLE = "simple";
    public static final String ANALYZING_TYPE_INDEX = "index";
    public static final String ANALYZING_TYPE_TITLE = "title";
    protected ParserRule parserRule;

    protected ParserFactory(ParserRule parserRule) {
        this.parserRule = parserRule;
    }

    public abstract FileParserResult parse();

    public static ParserFactory newInstance(ParserRule parserRule) {
        String fileType = parserRule.getTargetFileType();
        String analyzingType = parserRule.getAnalyzingType();
        if (FILE_TYPE_TXT.equalsIgnoreCase(fileType)) {
            if (ANALYZING_TYPE_SIMPLE.equalsIgnoreCase(analyzingType)) {
                return new SimpleTxtParser(parserRule);
            }
            if (ANALYZING_TYPE_INDEX.equalsIgnoreCase(analyzingType)) {
                return new IndexTxtParser(parserRule);
            }
            if (ANALYZING_TYPE_TITLE.equalsIgnoreCase(analyzingType)) {
                return new TitleTxtParser(parserRule);
            }
        }
        if (FILE_TYPE_XLS.equalsIgnoreCase(fileType)) {
            if (ANALYZING_TYPE_SIMPLE.equalsIgnoreCase(analyzingType)) {
                return new SimpleXlsParser(parserRule);
            }
            if (ANALYZING_TYPE_INDEX.equalsIgnoreCase(analyzingType)) {
                return new IndexXlsParser(parserRule);
            }
            if (ANALYZING_TYPE_TITLE.equalsIgnoreCase(analyzingType)) {
                return new TitleXlsParser(parserRule);
            }
        }
        return null;
    }

    public static FileParserResult parseFile(ParserRule parserRule) {
        ParserFactory pf = ParserFactory.newInstance(parserRule);
        if (pf != null) {
            return pf.parse();
        }
        return null;
    }
}

