/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.fileanalyzing.FileParserResult;
import com.cgd.base.fileanalyzing.ParserFactory;
import com.cgd.base.fileanalyzing.ParserRule;
import com.cgd.common.exception.ResourceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleTxtParser
extends ParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TitleTxtParser.class);

    public TitleTxtParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            String title = reader.readLine();
            if (title == null) {
                throw new ResourceException("F004", "\u8be5\u6a21\u677f\u7c7b\u578b\u5fc5\u987b\u6709\u6807\u9898!");
            }
            HashMap map = null;
            JSONObject titleToFieldNameRule = this.parserRule.get("keyTitleToFieldName");
            String separator = this.parserRule.getSeparator();
            ArrayList<String> titleCode = new ArrayList<String>();
            for (String value : title.split(separator)) {
                String fieldName = titleToFieldNameRule.getString(value);
                titleCode.add(fieldName);
            }
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line)) continue;
                map = new HashMap();
                String[] values = line.split(separator);
                int len = values.length;
                for (int j = 0; j < len; ++j) {
                    String value = values[j];
                    map.put(titleCode.get(j), value.trim());
                }
                result.add(map);
            }
        }
        catch (Exception ex) {
            LOG.error("\u5e26\u6807\u9898\u7684TXT\u89e3\u6790\u5f02\u5e38", (Throwable)ex);
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }
}

