/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnCompressGZFile {
    public static final int BYTE_LENGTH = 1024;
    private static Logger log = LoggerFactory.getLogger(UnCompressGZFile.class);

    public static String getFileName(String fileName) {
        String fname = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            fname = fileName.substring(0, i);
        }
        return fname;
    }

    public static String getExtension(String fileName) {
        String ext = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1);
        }
        return ext;
    }

    public static String unCompressGZFile(String inFile) {
        String outFileName = null;
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(inFile));){
            outFileName = UnCompressGZFile.getFileName(inFile);
            try (FileOutputStream fo = new FileOutputStream(outFileName);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    fo.write(buf, 0, len);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u4e0b\u8f7d\u5230\u672c\u5730\u8def\u5f84\uff1a{}", (Object)outFileName);
                }
                fo.flush();
            }
        }
        catch (FileNotFoundException e) {
            log.error("\u89e3\u538bGZ\u6587\u4ef6\u5f02\u5e38\uff0cGZIPInputStream-FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u89e3\u538bGZ\u6587\u4ef6\u5f02\u5e38\uff0cGZIPInputStream-IOException", (Throwable)e);
        }
        return outFileName;
    }

    public static String compressFile(String inFileName, String prefix) {
        File file = new File(inFileName);
        String str = file.getPath().substring(0, file.getPath().indexOf(file.getName())) + prefix + file.getName().substring(1);
        String outFileName = str + ".gz";
        try (FileInputStream in = new FileInputStream(new File(inFileName));
             GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFileName));){
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            if (log.isDebugEnabled()) {
                log.debug("Completing the GZIP file...{}", (Object)outFileName);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            log.error("Could not find the inFile not found error.." + inFileName, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not find the outFile IO error.." + outFileName, (Throwable)e);
        }
        return outFileName;
    }

    public static String reNameFile(String inFileName, String prefix) {
        File file = new File(inFileName);
        String str = file.getPath().substring(0, file.getPath().indexOf(file.getName())) + prefix + file.getName().substring(1);
        if (!inFileName.equals(str)) {
            boolean renameFlag;
            boolean delFlag;
            File f = new File(str);
            if (f.exists() && !(delFlag = f.delete())) {
                log.debug("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
            }
            if (!(renameFlag = file.renameTo(f))) {
                log.debug("\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25");
            }
        }
        return str;
    }
}

