/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.cgd.base.mq.MqProducerPool;
import com.cgd.base.util.LogUtils;
import com.cgd.base.util.SerializeUtils;

public class MqProducer {
    public static final String MQ_PRODUCER = "MqProducer";
    public static final String SEND_MSG = "sendMsg";
    private static MqProducerPool mqProducerPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMqProducerPool(MqProducerPool mqProducerPool) {
        Class<MqProducer> clazz = MqProducer.class;
        synchronized (MqProducer.class) {
            MqProducer.mqProducerPool = mqProducerPool;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void sendMsg(String topic, String tag, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, SerializeUtils.serialize(body));
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        try {
            producer.send(msg);
        }
        catch (Exception e) {
            LogUtils.printMQErrorLog(MQ_PRODUCER, SEND_MSG, msg, body, e);
        }
        LogUtils.printMQProducerLog(MQ_PRODUCER, SEND_MSG, msg, body);
    }

    public static void sendMsg(String topic, String tag, String key, Object body) {
        topic = mqProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, key, SerializeUtils.serialize(body));
        Producer producer = mqProducerPool.getProducer(topic);
        if (producer == null) {
            producer = mqProducerPool.getSynProducer(topic);
        }
        producer.send(msg);
        LogUtils.printMQProducerLog(MQ_PRODUCER, SEND_MSG, msg, body);
    }
}

