/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.cgd.base.mq.MqProducerPool;
import com.cgd.base.mq.NativeTransOnsProductor;
import com.cgd.common.cache.service.CacheService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqTranProducerPool {
    private static final Logger log = LoggerFactory.getLogger(MqTranProducerPool.class);
    private Map<String, TransactionProducer> producers = new HashMap<String, TransactionProducer>();
    private LocalTransactionChecker localTransactionChecker;
    private Properties propertyConfigurer;
    private boolean nativeOns = false;
    private CacheService cacheService;
    private Map<String, Properties> producerProperties = new HashMap<String, Properties>();

    public void setLocalTransactionChecker(LocalTransactionChecker localTransactionChecker) {
        this.localTransactionChecker = localTransactionChecker;
    }

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
    }

    public Properties getPropertyConfigurer() {
        return this.propertyConfigurer;
    }

    public boolean isNativeOns() {
        return this.nativeOns;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void init() {
        String accessKey = this.propertyConfigurer.getProperty("ons.AccessKey");
        String secretKey = this.propertyConfigurer.getProperty("ons.SecretKey");
        String namesrvAddr = this.propertyConfigurer.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.propertyConfigurer.getProperty("mq.ONSAddr");
        this.nativeOns = Boolean.parseBoolean(this.propertyConfigurer.getProperty("ons.native"));
        for (Object o : this.propertyConfigurer.keySet()) {
            String key = String.valueOf(o);
            if (!key.contains("_PID")) continue;
            String topicKey = key.substring(0, key.length() - 3) + "TOPIC";
            String topic = this.propertyConfigurer.getProperty(topicKey);
            topic = MqTranProducerPool.removeTrim(topic, "TOPIC\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01{PID:{},TOPIC:{}}", key, topicKey);
            NativeTransOnsProductor producer = null;
            if (this.nativeOns) {
                producer = new NativeTransOnsProductor(this.cacheService);
                producer.start();
            } else {
                String pid = this.propertyConfigurer.getProperty(key);
                pid = MqTranProducerPool.removeTrim(pid, "PID\u672a\u627e\u5230\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01{PID:{},TOPIC:{}}", key, topicKey);
                Properties properties = MqProducerPool.configRemoteMq(pid, accessKey, secretKey, namesrvAddr, oNSAddr);
                producer = ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)this.localTransactionChecker);
                producer.start();
                this.producerProperties.put(topic, properties);
            }
            this.producers.put(topic, producer);
        }
    }

    private static String removeTrim(String strTrim, String format, String key, String topicKey) {
        if (StringUtils.isNotBlank((CharSequence)strTrim)) {
            strTrim = strTrim.trim();
        } else {
            log.error(format, (Object)key, (Object)topicKey);
        }
        return strTrim;
    }

    public TransactionProducer getTransactionProducer(String topic) {
        return this.producers.get(topic);
    }

    public synchronized TransactionProducer getSynTransactionProducer(String topic) {
        return this.producers.computeIfAbsent(topic, k -> {
            Properties properties = this.producerProperties.get(topic);
            TransactionProducer tp = ONSFactory.createTransactionProducer((Properties)properties, (LocalTransactionChecker)this.localTransactionChecker);
            tp.start();
            return tp;
        });
    }
}

