/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.cgd.base.mq.MqConstants;
import com.cgd.base.mq.MqTranProducerPool;
import com.cgd.base.util.LogUtils;
import com.cgd.base.util.ReflectionUtils;
import com.cgd.base.util.SerializeUtils;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.exception.ResourceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqTransactionProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MqTransactionProducer.class);
    private static Map<Object, LocalTransactionExecuter> execters = new HashMap<Object, LocalTransactionExecuter>();
    private static Map<String, Method> localMethods = new HashMap<String, Method>();
    private static MqTranProducerPool mqTranProducerPool;
    private static CacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMqTranProducerPool(MqTranProducerPool mqTranProducerPool) {
        Class<MqTransactionProducer> clazz = MqTransactionProducer.class;
        synchronized (MqTransactionProducer.class) {
            MqTransactionProducer.mqTranProducerPool = mqTranProducerPool;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheService(CacheService cacheService) {
        Class<MqTransactionProducer> clazz = MqTransactionProducer.class;
        synchronized (MqTransactionProducer.class) {
            MqTransactionProducer.cacheService = cacheService;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void sendMsg(Object mqlocalexecuterservice, String method, Object arg, String topic, String tag, Object body) {
        topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, SerializeUtils.serialize(body));
        LocalTransactionExecuter localTransactionExecuter = MqTransactionProducer.getLocalTranExecuter(mqlocalexecuterservice, method, arg);
        TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);
        transactionProducer = MqTransactionProducer.getSynTransactionProducer(topic, transactionProducer);
        BusinessException.MQ_THREAD_EXCEPTION.remove();
        try {
            SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);
            LogUtils.printMQProducerLog(mqlocalexecuterservice.getClass().getName(), method, msg, body);
            LOG.debug("send tran msg msgId={} ,topic={}, tag={}, key={}, body={},  SendResult={}", new Object[]{msg.getMsgID(), topic, tag, msg.getKey(), body, srt});
            MqTransactionProducer.putCache(msg, MqConstants.PRODUCT_SEND_STATUS_SUCCESS, 600);
        }
        catch (BusinessException e) {
            LogUtils.printMQErrorLog(mqlocalexecuterservice.getClass().getName(), method, msg, body, e);
            MqTransactionProducer.putCache(msg, MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            throw new ResourceException(e.getMsgCode(), e.getMsgInfo());
        }
    }

    public static void sendMsg(Object mqlocalexecuterservice, String method, Object arg, String topic, String tag, String key, Object body) {
        topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, key, SerializeUtils.serialize(body));
        LocalTransactionExecuter localTransactionExecuter = MqTransactionProducer.getLocalTranExecuter(mqlocalexecuterservice, method, arg);
        TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);
        transactionProducer = MqTransactionProducer.getSynTransactionProducer(topic, transactionProducer);
        BusinessException.MQ_THREAD_EXCEPTION.remove();
        try {
            SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);
            LogUtils.printMQProducerLog(mqlocalexecuterservice.getClass().getName(), method, msg, body);
            LOG.debug("send tran msg msgId={} ,topic={}, tag={}, key={}, body={},  SendResult={}", new Object[]{msg.getMsgID(), topic, tag, msg.getKey(), body, srt});
            MqTransactionProducer.putCache(msg, MqConstants.PRODUCT_SEND_STATUS_SUCCESS, 600);
        }
        catch (BusinessException e) {
            MqTransactionProducer.putCache(msg, MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            LogUtils.printMQErrorLog(mqlocalexecuterservice.getClass().getName(), method, msg, body, e);
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
    }

    private static LocalTransactionExecuter getLocalTranExecuter(Object mqlocalexecuterservice, String methodName, Object args) {
        AbstractLocalTransactionExecuter localTransactionExecuter = (AbstractLocalTransactionExecuter)execters.get(mqlocalexecuterservice + methodName);
        if (localTransactionExecuter == null) {
            localTransactionExecuter = new AbstractLocalTransactionExecuter(mqlocalexecuterservice, methodName);
            execters.put(mqlocalexecuterservice + methodName, localTransactionExecuter);
        }
        localTransactionExecuter.setArgs(args);
        return localTransactionExecuter;
    }

    private static void putCache(Message msg, Integer mqSendStatus, Integer checkExpireTime) {
        if (!mqTranProducerPool.isNativeOns() && msg.getMsgID() != null) {
            cacheService.put(msg.getMsgID(), mqSendStatus, checkExpireTime);
        }
    }

    private static TransactionProducer getSynTransactionProducer(String topic, TransactionProducer transactionProducer) {
        if (transactionProducer == null) {
            transactionProducer = mqTranProducerPool.getSynTransactionProducer(topic);
        }
        return transactionProducer;
    }

    private static class AbstractLocalTransactionExecuter
    implements LocalTransactionExecuter {
        private ThreadLocal<Object> args = new ThreadLocal();
        private final Object mqLocalexecuterService;
        private final String methodName;

        public AbstractLocalTransactionExecuter(Object mqLocalexecuterService, String methodName) {
            this.mqLocalexecuterService = mqLocalexecuterService;
            this.methodName = methodName;
        }

        public void setArgs(Object args) {
            this.args.set(args);
        }

        public void unload() {
            this.args.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionStatus execute(Message msg, Object arg) {
            try {
                AbstractLocalTransactionExecuter.invokeMethod(this.mqLocalexecuterService, this.methodName, this.args.get());
            }
            catch (Exception e) {
                LOG.error("msgid:[" + msg.getMsgID() + "]\u672c\u5730\u4e8b\u52a1\u5f02\u5e38\uff0c\u9ed8\u8ba4\u56de\u6eda\u5e76\u56de\u6eda\u6d88\u606f", (Throwable)e);
                TransactionStatus transactionStatus = TransactionStatus.RollbackTransaction;
                return transactionStatus;
            }
            finally {
                this.args.remove();
            }
            return TransactionStatus.CommitTransaction;
        }

        private static void invokeMethod(Object mqlocalexecuterservice, String methodName, Object args) throws InvocationTargetException, IllegalAccessException {
            Method method = (Method)localMethods.get(mqlocalexecuterservice + methodName);
            if (method == null && (method = ReflectionUtils.getDeclaredMethod(mqlocalexecuterservice, methodName)) != null) {
                localMethods.put(mqlocalexecuterservice + methodName, method);
            }
            if (method != null) {
                method.invoke(mqlocalexecuterservice, args);
            }
        }
    }
}

