/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.cgd.base.mq.MqConstants;
import com.cgd.common.bo.MessageInfoBO;
import com.cgd.common.cache.service.CacheService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOnsProductor
implements Producer {
    private static final Logger LOG = LoggerFactory.getLogger(NativeOnsProductor.class);
    private CacheService cacheService;
    private boolean isStarted;

    public NativeOnsProductor(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        this.isStarted = true;
    }

    public void shutdown() {
        this.isStarted = false;
    }

    public SendResult send(Message message) {
        SendResult sendResult = new SendResult();
        String msgid = "NAV-" + System.nanoTime();
        sendResult.setMessageId(msgid);
        MessageInfoBO msgbo = new MessageInfoBO();
        msgbo.setBody(message.getBody());
        msgbo.setMsgId(msgid);
        msgbo.setTag(message.getTag());
        msgbo.setTopic(message.getTopic());
        msgbo.setMsgKey(message.getKey());
        msgbo.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
        msgbo.setSendTime(new Date());
        this.cacheService.put("LOCALMQ_" + msgid, msgbo);
        return sendResult;
    }

    public void sendOneway(Message message) {
        throw new UnsupportedOperationException("NativeOnsProductor not support sendOneway");
    }

    public void sendAsync(Message message, SendCallback sendCallback) {
        LOG.error("NativeOnsProductor not support sendAsync");
    }
}

