/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.cgd.base.mq.MqConstants;
import com.cgd.common.cache.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCheckListenerImpl
implements LocalTransactionChecker {
    private static final Logger log = LoggerFactory.getLogger(TransactionCheckListenerImpl.class);
    private static final boolean IS_DEBUG_ENABLE = log.isDebugEnabled();
    private CacheService cacheService;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public TransactionStatus check(Message msg) {
        String msgId = msg.getMsgID();
        String key = msg.getKey();
        String topic = msg.getTopic();
        String tag = msg.getTag();
        Object body = null;
        Integer status = (Integer)this.cacheService.get(msgId);
        if (status != null) {
            if (MqConstants.PRODUCT_SEND_STATUS_SUCCESS.equals(status)) {
                if (IS_DEBUG_ENABLE) {
                    log.debug("check msgId={}, topic={} ,tag={} ,key={}\u6d88\u606f\u53d1\u9001\u6210\u529f! body={}", new Object[]{msgId, topic, tag, key, body});
                }
                try {
                    this.cacheService.delete(msgId);
                    this.cacheService.delete("C_" + msgId);
                }
                catch (Exception e) {
                    log.error("\u5220\u9664redis\u4e2dkey{" + msgId + "} \u548c key {C_" + msgId + "}\u65f6\u5f02\u5e38", (Throwable)e);
                }
                return TransactionStatus.CommitTransaction;
            }
            if (MqConstants.PRODUCT_SEND_STATUS_FAILURE.equals(status)) {
                if (IS_DEBUG_ENABLE) {
                    log.debug("check  msgId={} topic={} tag={} key={}\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01 body={}", new Object[]{msgId, topic, tag, key, body});
                }
                try {
                    this.cacheService.delete(msgId);
                    this.cacheService.delete("C_" + msgId);
                }
                catch (Exception e) {
                    log.error("\u5220\u9664redis\u4e2dkey{" + msgId + "} \u548c key {C_" + msgId + "}\u65f6\u5f02\u5e38", (Throwable)e);
                }
                return TransactionStatus.RollbackTransaction;
            }
            log.warn("\u672a\u77e5\u7684\u534a\u4e8b\u52a1\u6d88\u606f\u72b6\u6001{}msg{}", (Object)status, (Object)msg);
            return TransactionStatus.RollbackTransaction;
        }
        Integer cstatus = (Integer)this.cacheService.get("C_" + msgId);
        if (cstatus != null) {
            Long dateTime = this.cacheService.getExpireTimeByKey("C_" + msgId);
            if (dateTime != null && (dateTime == -1L || dateTime == -2L)) {
                this.cacheService.delete(msgId);
                if (IS_DEBUG_ENABLE) {
                    log.debug("check msgId={} topic={} tag={}  key={}----\u65f6\u95f4\u8fc7\u957f\uff0c\u5220\u9664\u6d88\u606f!", new Object[]{msgId, topic, tag, key});
                }
                return TransactionStatus.RollbackTransaction;
            }
            if (IS_DEBUG_ENABLE) {
                log.debug("check msgId={} topic={} tag={}  key={}\u72b6\u6001\u672a\u77e5!", new Object[]{msgId, topic, tag, key});
            }
            return TransactionStatus.Unknow;
        }
        if (IS_DEBUG_ENABLE) {
            log.debug("check msgId={} topic={} tag={}  key={}\u7b2c\u4e00\u6b21check\u4e0d\u5230\uff0c\u6dfb\u52a0\u4e00\u6761\u6d88\u606f", new Object[]{msgId, topic, tag, key});
        }
        this.cacheService.put("C_" + msgId, MqConstants.PRODUCT_SEND_STATUS_TIMETOOLONG, 7200);
        return TransactionStatus.Unknow;
    }
}

