/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.out;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cgd.base.out.UniBssUtil;
import com.cgd.base.out.bo.Reserved;
import com.cgd.base.out.bo.UniBssAttached;
import com.cgd.base.out.bo.UniBssHead;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutSendToAopUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OutSendToAopUtil.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

    private OutSendToAopUtil() {
        throw new UnsupportedOperationException("OutSendToAopUtil\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static String toUniBssStringOut(UniBssHead uniBssHead, UniBssAttached uniBssAttached, Object obj) throws JsonProcessingException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("uniBssAttached", (Object)uniBssAttached);
        jsonObj.put("uniBssHead", (Object)uniBssHead);
        JSONObject uniBssBody = new JSONObject();
        String objStr = obj.getClass().getSimpleName();
        uniBssBody.put(UniBssUtil.toLowerHeadString(objStr), obj);
        jsonObj.put("uniBssBody", (Object)uniBssBody);
        ObjectMapper om = new ObjectMapper();
        JsonNode node = null;
        node = om.readTree(jsonObj.toString());
        StringBuilder json = new StringBuilder();
        int deep = 0;
        UniBssUtil.jsonFormat(node, json, deep, true);
        if (isDebugEnabled) {
            LOG.debug("OutSendToAopUtil:json-{}", (Object)json);
        }
        return json.toString();
    }

    public static String requestToAOP(String requestUrl, String requestStr) throws IOException {
        if (isDebugEnabled) {
            LOG.debug("requestToAOP:requestUrl={},requestStr={}", (Object)requestUrl, (Object)requestStr);
        }
        HttpPost httpPost = new HttpPost(requestUrl);
        httpPost.addHeader("Content-Type", APPLICATION_JSON);
        StringEntity se = new StringEntity(requestStr, StandardCharsets.UTF_8);
        se.setContentType(CONTENT_TYPE_TEXT_JSON);
        se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
        httpPost.setEntity((HttpEntity)se);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)entity);
            if (isDebugEnabled) {
                LOG.debug("OutSendToAopUtil:responseStr-{}", (Object)responseStr);
            }
            String string = responseStr;
            return string;
        }
    }

    public static UniBssHead getUniBssHead(String appId, String appSecret) {
        if (isDebugEnabled) {
            LOG.debug("getUniBssHead:appId-{},appSecret-{}", (Object)appId, (Object)appSecret);
        }
        UniBssHead uniBssHead = new UniBssHead();
        String transId = UniBssUtil.getTransId();
        String timestamp = UniBssUtil.getTimeStamp();
        String token = UniBssUtil.getToken(appId, timestamp, transId, appSecret);
        uniBssHead.setAppId(appId);
        uniBssHead.setTimestamp(timestamp);
        uniBssHead.setToken(token);
        uniBssHead.setTransId(transId);
        ArrayList<Reserved> reserved = new ArrayList<Reserved>();
        Reserved res = new Reserved();
        reserved.add(res);
        uniBssHead.setReserved(reserved);
        if (isDebugEnabled) {
            LOG.debug("OutSendToAopUtil:uniBssHead-{}", (Object)uniBssHead);
        }
        return uniBssHead;
    }

    public static String toUniBssStringIn(String aopString) throws JsonProcessingException {
        if (isDebugEnabled) {
            LOG.debug("toUniBssStringIn:aopString-{}", (Object)aopString);
        }
        ObjectMapper om = new ObjectMapper();
        JsonNode node = null;
        node = om.readTree(aopString);
        StringBuilder json = new StringBuilder();
        int deep = 0;
        UniBssUtil.jsonFormat(node, json, deep, false);
        return json.toString();
    }

    public static Object getObjectByString(String objStr, String aopString) throws JsonProcessingException {
        if (isDebugEnabled) {
            LOG.debug("getObjectByString:objStr-{},aopString-{}", (Object)objStr, (Object)aopString);
        }
        String uniBssString = OutSendToAopUtil.toUniBssStringIn(aopString);
        ObjectMapper om = new ObjectMapper();
        return ((HashMap)om.readValue(uniBssString, HashMap.class)).get(objStr);
    }

    public static UniBssHead getUniBssHead(String aopString) throws JsonProcessingException {
        if (isDebugEnabled) {
            LOG.debug("getUniBssHead:aopString-{}", (Object)aopString);
        }
        Object uniBssHeadObj = OutSendToAopUtil.getObjectByString("uniBssHead", aopString);
        ObjectMapper om = new ObjectMapper();
        return (UniBssHead)om.readValue(JSON.toJSONString((Object)uniBssHeadObj), UniBssHead.class);
    }

    public static <V> V getJavaBean(String javaBeanName, String aopString, Class<V> valueType) throws JsonProcessingException {
        if (isDebugEnabled) {
            LOG.debug("getJavaBean:javaBeanName-{},aopString-{},valueType={}", new Object[]{javaBeanName, aopString, valueType});
        }
        Object uniBssBody = OutSendToAopUtil.getObjectByString("uniBssBody", aopString);
        ObjectMapper om = new ObjectMapper();
        Object javaBeanObj = ((HashMap)om.readValue(JSON.toJSONString((Object)uniBssBody), HashMap.class)).get(javaBeanName);
        return (V)om.readValue(JSON.toJSONString(javaBeanObj), valueType);
    }
}

