/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import com.cgd.base.util.DBBatchInterface;
import com.cgd.common.exception.BusinessException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DbUtils.class);
    public static final int DB_BATCH_DEFAULT_STEP = 100;
    private DataSource mysqlDataSource;

    public DataSource getMysqlDataSource() {
        return this.mysqlDataSource;
    }

    public void setMysqlDataSource(DataSource mysqlDataSource) {
        this.mysqlDataSource = mysqlDataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(String sql, List<Object> paramList) {
        if (sql == null) throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (sql.trim().equals("")) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int result = 0;
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = DbUtils.getPreparedStatement(conn, sql);){
            this.setPreparedStatementParam(stmt, paramList);
            if (stmt == null) {
                int n = -1;
                return n;
            }
            result = stmt.executeUpdate();
            return result;
        }
        catch (SQLException e) {
            LOG.error("SQL\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> getQueryList(String sql, List<Object> paramList) {
        if (sql == null) return new ArrayList<Map<String, Object>>();
        if (sql.trim().equals("")) {
            return new ArrayList<Map<String, Object>>();
        }
        ResultSet rs = null;
        List<Map<String, Object>> queryList = null;
        try {
            Connection conn = this.getConnection();
            Throwable throwable = null;
            try {
                Throwable throwable2;
                PreparedStatement stmt;
                block36: {
                    ArrayList<Map<String, Object>> arrayList;
                    block37: {
                        block38: {
                            stmt = DbUtils.getPreparedStatement(conn, sql);
                            throwable2 = null;
                            this.setPreparedStatementParam(stmt, paramList);
                            if (stmt != null) break block36;
                            arrayList = new ArrayList<Map<String, Object>>();
                            if (stmt == null) break block37;
                            if (throwable2 == null) break block38;
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block37;
                        }
                        stmt.close();
                    }
                    if (conn != null) {
                        if (throwable != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            conn.close();
                        }
                    }
                    this.closeResultSet(rs);
                    return arrayList;
                }
                try {
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    rs = this.getResultSet(stmt);
                    queryList = this.getQueryList(rs);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                throw throwable9;
            }
            this.closeResultSet(rs);
            return queryList;
        }
        catch (SQLException e) {
            try {
                LOG.error("getQueryList error", (Throwable)e);
                throw new BusinessException("8888", "getQueryList\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u65e5\u5fd7");
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public void setPreparedStatementParam(PreparedStatement pstmt, List<Object> paramList) throws SQLException {
        if (pstmt == null || paramList == null || paramList.isEmpty()) {
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance();
        for (int i = 0; i < paramList.size(); ++i) {
            if (paramList.get(i) instanceof Integer) {
                int paramValue = (Integer)paramList.get(i);
                pstmt.setInt(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Float) {
                float paramValue = ((Float)paramList.get(i)).floatValue();
                pstmt.setFloat(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Double) {
                double paramValue = (Double)paramList.get(i);
                pstmt.setDouble(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Date) {
                pstmt.setString(i + 1, df.format((Date)paramList.get(i)));
                continue;
            }
            if (paramList.get(i) instanceof Long) {
                long paramValue = (Long)paramList.get(i);
                pstmt.setLong(i + 1, paramValue);
                continue;
            }
            if (!(paramList.get(i) instanceof String)) continue;
            pstmt.setString(i + 1, (String)paramList.get(i));
        }
    }

    public Connection getConnection() throws SQLException {
        return this.mysqlDataSource.getConnection();
    }

    public static PreparedStatement getPreparedStatement(Connection conn, String sql) throws SQLException {
        if (conn == null || sql == null || sql.trim().equals("")) {
            return null;
        }
        return conn.prepareStatement(sql.trim());
    }

    private ResultSet getResultSet(PreparedStatement pstmt) throws SQLException {
        if (pstmt == null) {
            return null;
        }
        return pstmt.executeQuery();
    }

    private List<Map<String, Object>> getQueryList(ResultSet rs) throws SQLException {
        if (rs == null) {
            return new ArrayList<Map<String, Object>>();
        }
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                dataMap.put(rsMetaData.getColumnName(i + 1), rs.getObject(i + 1));
            }
            dataList.add(dataMap);
        }
        return dataList;
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            LOG.error("\u5173\u95edResultSet\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u5173\u95ed\u6570\u636e\u5e93\u7ed3\u679c\u4e00\u573a");
        }
    }

    public static <T> void execBatch(List<T> list, DBBatchInterface<T> dbBatchInterface) {
        DbUtils.execBatch(list, 100, dbBatchInterface);
    }

    public static <T> void execBatch(List<T> list, int step, DBBatchInterface<T> dbBatchInterface) {
        for (int start = 0; start < list.size(); start += step) {
            int end = start + step > list.size() ? list.size() : start + step;
            dbBatchInterface.doBatch(list.subList(start, end));
        }
    }
}

