/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DelFormatHelper {
    private static final String SDF_17_STRING = "yyyyMMddHHmmssSSS";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF_17 = new ThreadLocal();
    private static final String SDF_14_STRING = "yyyyMMddHHmmss";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF_14 = new ThreadLocal();
    private static final String SDF_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF = new ThreadLocal();
    private static final String SDF_YEAR_MONTH_STRING = "yyyyMM";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF_YEAR_MONTH = new ThreadLocal();
    private static final String SDF_YEAR_MONTH_DAY_STRING = "yyyyMMdd";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF_YEAR_MONTH_DAY = new ThreadLocal();
    private static final String SDF_YEAR_MONTH_DAY_2_STRING = "yyyy-MM-dd";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2 = new ThreadLocal();
    private static final String SDFYMDHM_STRING = "yyyy-MM-dd HH:mm";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_SDFYMDHMG = new ThreadLocal();

    private static SimpleDateFormat getSdf17() {
        SimpleDateFormat sdf17 = THREAD_LOCAL_SDF_17.get();
        if (sdf17 == null) {
            sdf17 = new SimpleDateFormat(SDF_17_STRING);
            THREAD_LOCAL_SDF_17.set(sdf17);
        }
        return sdf17;
    }

    private static SimpleDateFormat getSdf14() {
        SimpleDateFormat sdf14 = THREAD_LOCAL_SDF_14.get();
        if (sdf14 == null) {
            sdf14 = new SimpleDateFormat(SDF_14_STRING);
            THREAD_LOCAL_SDF_14.set(sdf14);
        }
        return sdf14;
    }

    private static SimpleDateFormat getDateSdf() {
        SimpleDateFormat sdf = THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(SDF_YEAR_MONTH_DAY_2_STRING);
            THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2.set(sdf);
        }
        return sdf;
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat sdf = THREAD_LOCAL_SDF.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat(SDF_STRING);
            THREAD_LOCAL_SDF.set(sdf);
        }
        return sdf;
    }

    private static SimpleDateFormat getSdfYearMonth() {
        SimpleDateFormat sdfYearMonth = THREAD_LOCAL_SDF_YEAR_MONTH.get();
        if (sdfYearMonth == null) {
            sdfYearMonth = new SimpleDateFormat(SDF_YEAR_MONTH_STRING);
            THREAD_LOCAL_SDF_YEAR_MONTH.set(sdfYearMonth);
        }
        return sdfYearMonth;
    }

    private static SimpleDateFormat getSdfymdhmDay() {
        SimpleDateFormat sdfymdhmDay = THREAD_LOCAL_SDFYMDHMG.get();
        if (sdfymdhmDay == null) {
            sdfymdhmDay = new SimpleDateFormat(SDFYMDHM_STRING);
            THREAD_LOCAL_SDFYMDHMG.set(sdfymdhmDay);
        }
        return sdfymdhmDay;
    }

    private static SimpleDateFormat getSdfYearMonthDay() {
        SimpleDateFormat sdfYearMonthDay = THREAD_LOCAL_SDF_YEAR_MONTH_DAY.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(SDF_YEAR_MONTH_DAY_STRING);
            THREAD_LOCAL_SDF_YEAR_MONTH_DAY.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static String getDateStringFor14Nums() {
        return DelFormatHelper.getSdf14().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowTimeForString() {
        return DelFormatHelper.getSdf().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowTimeForString(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf14().format(DelFormatHelper.getSdf().parse(dateStr));
    }

    public static Date fromSdfToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf().parse(dateStr);
    }

    public static Date strToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getDateSdf().parse(dateStr);
    }

    public static Date fromStrymdhmToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdfymdhmDay().parse(dateStr);
    }

    public static Date fromSdf17ToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf17().parse(dateStr);
    }

    public static Date fromSdf14ToDate(String dateStr) throws ParseException {
        return DelFormatHelper.getSdf14().parse(dateStr);
    }

    public static String fromDateToSdf17(Date date) {
        return DelFormatHelper.getSdf17().format(date);
    }

    public static Integer getNowYearAndMonth() {
        return Integer.parseInt(DelFormatHelper.getSdfYearMonth().format(new Date(System.currentTimeMillis())));
    }

    public static String getNowYearAndMonthDayString() {
        return DelFormatHelper.getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
    }

    public static Integer[] getOldSexMonthBefNow() {
        Integer[] months = new Integer[6];
        SimpleDateFormat format = DelFormatHelper.getSdfYearMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        for (int i = 1; i < 7; ++i) {
            calendar.add(2, -1);
            Date month = calendar.getTime();
            months[i - 1] = Integer.parseInt(format.format(month));
        }
        return months;
    }

    public static String getYesterdayYearMonthDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_YEAR_MONTH_DAY_STRING);
        return sdf.format(date);
    }

    public static String getForworday() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        return sdf.format(date);
    }

    private static SimpleDateFormat getSdfYmdhm() {
        SimpleDateFormat sdfYearMonthDay = THREAD_LOCAL_SDFYMDHMG.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(SDFYMDHM_STRING);
            THREAD_LOCAL_SDFYMDHMG.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static String getNowYearMothDayHourMin() {
        return DelFormatHelper.getSdfYmdhm().format(new Date(System.currentTimeMillis()));
    }

    public static String getNowYearAndMonthString() {
        return DelFormatHelper.getSdfYearMonth().format(new Date(System.currentTimeMillis()));
    }

    public static SimpleDateFormat getSdfYearMonthDay2() {
        SimpleDateFormat sdfYearMonthDay = THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2.get();
        if (sdfYearMonthDay == null) {
            sdfYearMonthDay = new SimpleDateFormat(SDF_YEAR_MONTH_DAY_2_STRING);
            THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2.set(sdfYearMonthDay);
        }
        return sdfYearMonthDay;
    }

    public static Date getNowYearAndMonthDay() throws ParseException {
        String dateStr = DelFormatHelper.getSdfYearMonthDay().format(new Date(System.currentTimeMillis()));
        return DelFormatHelper.getSdfYearMonthDay().parse(dateStr);
    }

    public static Date getNowYearAndMonthDay(String dateStr) throws ParseException {
        return DelFormatHelper.getSdfYearMonthDay().parse(dateStr);
    }

    public static Date longToDate(long currentTime) {
        return new Date(currentTime);
    }

    public static String fromDateToSdf(Date date) {
        return DelFormatHelper.getSdf().format(date);
    }

    public static String fromDateToStr(Date date) {
        return DelFormatHelper.getDateSdf().format(date);
    }

    public void unload() {
        THREAD_LOCAL_SDF_17.remove();
        THREAD_LOCAL_SDF_14.remove();
        THREAD_LOCAL_SDF.remove();
        THREAD_LOCAL_SDF_YEAR_MONTH.remove();
        THREAD_LOCAL_SDF_YEAR_MONTH_DAY.remove();
        THREAD_LOCAL_SDF_YEAR_MONTH_DAY_2.remove();
        THREAD_LOCAL_SDFYMDHMG.remove();
    }
}

