/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportUtil.class);

    private ExportUtil() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static void exportExcel(String fileName, String sheetName, String titleName, String[] headers, Collection<?> dataSet, String pattern, HttpServletResponse response) {
        ExportUtil.doExportExcel(fileName, sheetName, titleName, headers, dataSet, pattern, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExportExcel(String fileName, String sheetName, String titleName, String[] headers, Collection<?> dataSet, String pattern, HttpServletResponse response) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName + 1);
        sheet.setDefaultColumnWidth(20);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headers.length - 1));
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillForegroundColor((short)9);
        titleStyle.setBorderBottom((short)1);
        titleStyle.setBorderLeft((short)1);
        titleStyle.setBorderRight((short)1);
        titleStyle.setBorderTop((short)1);
        titleStyle.setAlignment((short)2);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setColor((short)8);
        titleFont.setFontHeightInPoints((short)22);
        titleFont.setBoldweight((short)700);
        titleStyle.setFont(titleFont);
        HSSFCellStyle headersStyle = workbook.createCellStyle();
        headersStyle.setFillForegroundColor((short)9);
        headersStyle.setFillPattern((short)1);
        headersStyle.setBorderBottom((short)1);
        headersStyle.setBorderLeft((short)1);
        headersStyle.setBorderRight((short)1);
        headersStyle.setBorderTop((short)1);
        headersStyle.setAlignment((short)2);
        HSSFFont headersFont = workbook.createFont();
        headersFont.setColor((short)8);
        headersFont.setFontHeightInPoints((short)13);
        headersFont.setBoldweight((short)700);
        headersStyle.setFont(headersFont);
        HSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor((short)9);
        dataSetStyle.setBorderBottom((short)1);
        dataSetStyle.setBorderLeft((short)1);
        dataSetStyle.setBorderRight((short)1);
        dataSetStyle.setBorderTop((short)1);
        dataSetStyle.setAlignment((short)2);
        dataSetStyle.setVerticalAlignment((short)1);
        HSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setBoldweight((short)400);
        dataSetFont.setColor((short)8);
        dataSetStyle.setFont(dataSetFont);
        HSSFRow titleRow = sheet.createRow(0);
        HSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellStyle(titleStyle);
        titleCell.setCellValue(titleName);
        HSSFRow row = sheet.createRow(1);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headersStyle);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        HSSFCellStyle cellStyle1 = workbook.createCellStyle();
        Iterator<?> it = dataSet.iterator();
        int index = 1;
        int sheetCount = 0;
        while (it.hasNext()) {
            if (sheetCount > 0 && sheetCount % 10000 == 0) {
                index = 1;
                sheet = workbook.createSheet(sheetName + (sheetCount / 10000 + 1));
                sheet.setDefaultColumnWidth(20);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headers.length - 1));
                titleStyle = workbook.createCellStyle();
                titleStyle.setFillForegroundColor((short)9);
                titleStyle.setBorderBottom((short)1);
                titleStyle.setBorderLeft((short)1);
                titleStyle.setBorderRight((short)1);
                titleStyle.setBorderTop((short)1);
                titleStyle.setAlignment((short)2);
                titleFont = workbook.createFont();
                titleFont.setColor((short)8);
                titleFont.setFontHeightInPoints((short)22);
                titleFont.setBoldweight((short)700);
                titleStyle.setFont(titleFont);
                headersStyle = workbook.createCellStyle();
                headersStyle.setFillForegroundColor((short)9);
                headersStyle.setFillPattern((short)1);
                headersStyle.setBorderBottom((short)1);
                headersStyle.setBorderLeft((short)1);
                headersStyle.setBorderRight((short)1);
                headersStyle.setBorderTop((short)1);
                headersStyle.setAlignment((short)2);
                headersFont = workbook.createFont();
                headersFont.setColor((short)8);
                headersFont.setFontHeightInPoints((short)13);
                headersFont.setBoldweight((short)700);
                headersStyle.setFont(headersFont);
                dataSetStyle = workbook.createCellStyle();
                dataSetStyle.setFillForegroundColor((short)9);
                dataSetStyle.setBorderBottom((short)1);
                dataSetStyle.setBorderLeft((short)1);
                dataSetStyle.setBorderRight((short)1);
                dataSetStyle.setBorderTop((short)1);
                dataSetStyle.setAlignment((short)2);
                dataSetStyle.setVerticalAlignment((short)1);
                dataSetFont = workbook.createFont();
                dataSetFont.setBoldweight((short)400);
                dataSetFont.setColor((short)8);
                dataSetStyle.setFont(dataSetFont);
                titleRow = sheet.createRow(0);
                titleCell = titleRow.createCell(0);
                titleCell.setCellStyle(titleStyle);
                titleCell.setCellValue(titleName);
                row = sheet.createRow(1);
                for (short i = 0; i < headers.length; i = (short)(i + 1)) {
                    HSSFCell cell = row.createCell(i);
                    cell.setCellStyle(headersStyle);
                    HSSFRichTextString text = new HSSFRichTextString(headers[i]);
                    cell.setCellValue((RichTextString)text);
                }
            }
            row = sheet.createRow(++index);
            Object t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (short i = 0; i < fields.length; i = (short)(i + 1)) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(dataSetStyle);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    if (null == value) {
                        value = "";
                    }
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                        HSSFCreationHelper creationHelper = workbook.getCreationHelper();
                        cellStyle1.setDataFormat(creationHelper.createDataFormat().getFormat(pattern));
                        cellStyle1.setFillForegroundColor((short)9);
                        cellStyle1.setBorderBottom((short)1);
                        cellStyle1.setBorderLeft((short)1);
                        cellStyle1.setBorderRight((short)1);
                        cellStyle1.setBorderTop((short)1);
                        cellStyle1.setAlignment((short)2);
                        cellStyle1.setVerticalAlignment((short)1);
                        dataSetFont = workbook.createFont();
                        dataSetFont.setBoldweight((short)400);
                        dataSetFont.setColor((short)8);
                        cellStyle1.setFont((Font)dataSetFont);
                        cell.setCellStyle((CellStyle)cellStyle1);
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    cell.setCellValue(textValue);
                    continue;
                }
                catch (SecurityException e) {
                    LOGGER.error("SecurityException error", (Throwable)e);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("NoSuchMethodException error", (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("IllegalArgumentException error", (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("IllegalAccessException error", (Throwable)e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("InvocationTargetException error", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        workbook.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("\u5173\u95edworkbook\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            ++sheetCount;
        }
        String encodedfileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        String fileType = ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=\"" + encodedfileName + fileType + "\"");
        response.setContentType("application/x-download");
        try {
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
        }
    }

    public static List<?> importExcel(File ossFile, int startRow, int endRow, Class<?> clazz) throws IOException {
        boolean showInfo = true;
        return ExportUtil.doImportExcel(ossFile, startRow, endRow, showInfo, clazz);
    }

    private static List<Object> doImportExcel(File ossFile, int startRow, int endRow, boolean showInfo, Class<?> clazz) throws IOException {
        ArrayList<Row> rowList = new ArrayList<Row>();
        try (FileInputStream fis = new FileInputStream(ossFile);
             HSSFWorkbook wb = new HSSFWorkbook((InputStream)fis);){
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum > 0) {
                ExportUtil.out("\n\u5f00\u59cb\u8bfb\u53d6\u540d\u4e3a\u3010" + sheet.getSheetName() + "\u3011\u7684\u5185\u5bb9\uff1a", showInfo);
            }
            Row row = null;
            for (int i = startRow; i <= lastRowNum + endRow; ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                rowList.add(row);
                ExportUtil.out("\u7b2c" + (i + 1) + "\u884c\uff1a", showInfo, false);
                for (int j = 0; j < row.getLastCellNum(); ++j) {
                    Cell infoCell = row.getCell(j);
                    infoCell.setCellType(1);
                    String value = infoCell.getStringCellValue();
                    if (value.equals("")) continue;
                    ExportUtil.out(value + " | ", showInfo, false);
                }
                ExportUtil.out("", showInfo);
            }
        }
        catch (IOException e) {
            LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-doImportExcel]-\u5f02\u5e38", (Throwable)e);
        }
        return ExportUtil.returnObjectList(rowList, clazz);
    }

    private static String getCellValue(Cell cell) {
        Object result = "";
        if (cell != null && cell.getStringCellValue() != "") {
            switch (cell.getCellType()) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    result = cell.getNumericCellValue();
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 2: {
                    result = cell.getCellFormula();
                    break;
                }
                case 5: {
                    result = cell.getErrorCellValue();
                    break;
                }
            }
        }
        return result.toString();
    }

    private static List<Object> returnObjectList(List<Row> rowList, Class<?> clazz) {
        ArrayList<Object> objectList = null;
        Object obj = null;
        String attribute = null;
        String value = null;
        int j = 0;
        try {
            objectList = new ArrayList<Object>();
            Field[] declaredFields = clazz.getDeclaredFields();
            for (Row row : rowList) {
                j = 0;
                obj = clazz.newInstance();
                for (Field field : declaredFields) {
                    attribute = field.getName();
                    value = ExportUtil.getCellValue(row.getCell(j));
                    ExportUtil.setAttrributeValue(obj, attribute, value);
                    ++j;
                }
                objectList.add(obj);
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-returnObjectList]-\u5f02\u5e38", (Throwable)e);
        }
        return objectList;
    }

    private static void setAttrributeValue(Object obj, String attribute, String value) {
        Method[] methods;
        String methodName = ExportUtil.convertToMethodName(attribute, obj.getClass(), true);
        String formatmethod = "set" + methodName.substring(3, 4).toUpperCase() + methodName.substring(4);
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(formatmethod)) continue;
            Class<?>[] parameterC = method.getParameterTypes();
            try {
                if (parameterC[0] == Integer.TYPE || parameterC[0] == Integer.class) {
                    value = value.substring(0, value.lastIndexOf("."));
                    method.invoke(obj, Integer.valueOf(value));
                    break;
                }
                if (parameterC[0] == Float.TYPE || parameterC[0] == Float.class) {
                    method.invoke(obj, Float.valueOf(value));
                    break;
                }
                if (parameterC[0] == Double.TYPE || parameterC[0] == Double.class) {
                    method.invoke(obj, Double.valueOf(value));
                    break;
                }
                if (parameterC[0] == Byte.TYPE || parameterC[0] == Byte.class) {
                    method.invoke(obj, Byte.valueOf(value));
                    break;
                }
                if (parameterC[0] == Boolean.TYPE || parameterC[0] == Boolean.class) {
                    method.invoke(obj, Boolean.valueOf(value));
                    break;
                }
                if (parameterC[0] == Long.TYPE || parameterC[0] == Long.class) {
                    method.invoke(obj, Long.valueOf(value));
                    break;
                }
                if (parameterC[0] == Date.class) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = sdf.parse(value);
                    method.invoke(obj, date);
                    break;
                }
                method.invoke(obj, parameterC[0].cast(value));
                break;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-setAttrributeValue]-IllegalArgumentException\u5f02\u5e38", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-setAttrributeValue]-IllegalAccessException\u5f02\u5e38", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-setAttrributeValue]-InvocationTargetException\u5f02\u5e38", (Throwable)e);
            }
            catch (SecurityException | ParseException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-setAttrributeValue]-SecurityException\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private static String convertToMethodName(String attribute, Class<?> objClass, boolean isSet) {
        Pattern p = Pattern.compile("[\\s\\S]*?");
        Matcher m = p.matcher(attribute);
        StringBuilder sb = new StringBuilder();
        if (isSet) {
            sb.append("set");
        } else {
            try {
                Field attributeField = objClass.getDeclaredField(attribute);
                if (attributeField.getType() == Boolean.TYPE || attributeField.getType() == Boolean.class) {
                    sb.append("is");
                } else {
                    sb.append("get");
                }
            }
            catch (SecurityException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-convertToMethodName]-SecurityException\u5f02\u5e38", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("[\u57fa\u7840\u7ec4\u4ef6-convertToMethodName]-NoSuchFieldException\u5f02\u5e38", (Throwable)e);
            }
        }
        if (attribute.charAt(0) != '_' && m.find()) {
            sb.append(m.replaceFirst(m.group().toUpperCase()));
        } else {
            sb.append(attribute);
        }
        return sb.toString();
    }

    private static void out(String info, boolean showInfo) {
        if (showInfo) {
            LOGGER.debug(info + "\n");
        }
    }

    private static void out(String info, boolean showInfo, boolean nextLine) {
        if (showInfo) {
            if (nextLine) {
                LOGGER.debug(info + "\n");
            } else {
                LOGGER.debug(info);
            }
        }
    }
}

