/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formula {
    private static final Logger LOG = LoggerFactory.getLogger(Formula.class);
    private int leftBracket = 0;
    private int rightBracket = 0;
    private int startL = 0;
    private int startR = 0;
    private double answer = 0.0;
    private String leftNumber = "0";
    private String rightNumber = "0";
    private String msg = "";
    private String formulaStr = "";
    private int[] sym = new int[4];
    private Vector<String> list = new Vector();
    static Vector<Integer> paras = new Vector();

    public Formula(String calRule) {
        this.setFormulaStr(calRule);
    }

    private int getLeftBracket(String calRule) {
        this.leftBracket = 0;
        this.startL = calRule.indexOf("(");
        if (this.startL != -1) {
            calRule = calRule.substring(this.startL + 1, calRule.length());
        }
        while (this.startL != -1) {
            ++this.leftBracket;
            this.startL = calRule.indexOf("(");
            calRule = calRule.substring(this.startL + 1, calRule.length());
        }
        return this.leftBracket;
    }

    public void setFormulaStr(String calRule) {
        this.formulaStr = this.replaceSubtration(calRule.trim());
        this.formulaStr = "(" + this.formulaStr + ")";
    }

    private String replaceSubtration(String vstr) {
        String tmp = "";
        StringBuilder result = new StringBuilder();
        int startS = vstr.indexOf("-");
        if (startS != -1) {
            if (startS > 0) {
                tmp = vstr.substring(startS - 1, startS);
                if (!("+".equals(tmp) || "-".equals(tmp) || "*".equals(tmp) || "/".equals(tmp) || "(".equals(tmp))) {
                    result.append(vstr.substring(0, startS)).append("`");
                } else {
                    result.append(vstr.substring(0, startS + 1));
                }
            } else {
                result.append(vstr.substring(0, startS + 1));
            }
            vstr = vstr.substring(startS + 1);
        }
        while (startS != -1) {
            startS = vstr.indexOf("-");
            if (startS > 0) {
                tmp = vstr.substring(startS - 1, startS);
                if (!("+".equals(tmp) || "-".equals(tmp) || "*".equals(tmp) || "/".equals(tmp) || "(".equals(tmp))) {
                    result.append(vstr.substring(0, startS)).append("`");
                } else {
                    result.append(vstr.substring(0, startS + 1));
                }
            } else {
                result.append(vstr.substring(0, startS + 1));
            }
            vstr = vstr.substring(startS + 1);
        }
        result.append(vstr);
        return result.toString();
    }

    public String getFormulaStr() {
        return this.formulaStr.replace('`', '-').substring(1, this.formulaStr.length() - 1);
    }

    private int getRightBracket(String calRule) {
        this.rightBracket = 0;
        this.startR = calRule.indexOf(")");
        if (this.startR != -1) {
            calRule = calRule.substring(this.startR + 1, calRule.length());
        }
        while (this.startR != -1) {
            ++this.rightBracket;
            this.startR = calRule.indexOf(")");
            calRule = calRule.substring(this.startR + 1, calRule.length());
        }
        return this.rightBracket;
    }

    private boolean compareToLR() {
        int lb = this.getLeftBracket(this.formulaStr);
        int rb = this.getRightBracket(this.formulaStr);
        boolean ctlr = false;
        if (lb == rb) {
            this.msg = "";
            ctlr = true;
        } else if (lb > rb) {
            this.msg = "\u5de6\u62ec\u5f27\u7684\u4e2a\u6570\u591a\u4e8e\u53f3\u62ec\u5f27\uff0c\u8bf7\u68c0\u67e5\uff01";
            ctlr = false;
        } else {
            this.msg = "\u5de6\u62ec\u5f27\u7684\u4e2a\u6570\u5c11\u4e8e\u53f3\u62ec\u5f27\uff0c\u8bf7\u68c0\u67e5\uff01";
            ctlr = false;
        }
        return ctlr;
    }

    private boolean checkFormula() {
        int j;
        int i;
        boolean isOk = true;
        String[] bracket = new String[2];
        String[] sign = new String[4];
        bracket[0] = "(";
        bracket[1] = ")";
        sign[0] = "+";
        sign[1] = "`";
        sign[2] = "*";
        sign[3] = "/";
        String vstr = "";
        for (i = 0; i < bracket.length; ++i) {
            for (j = 0; j < sign.length; ++j) {
                vstr = i == 0 ? bracket[i] + sign[j] : sign[j] + bracket[i];
                if (this.formulaStr.indexOf(vstr) <= 0) continue;
                this.msg = "\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26" + vstr;
                isOk = false;
                return isOk;
            }
        }
        for (i = 0; i < sign.length; ++i) {
            for (j = 0; j < sign.length; ++j) {
                vstr = sign[i] + sign[j];
                if (this.formulaStr.indexOf(vstr) <= 0) continue;
                this.msg = "\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26" + vstr;
                isOk = false;
                return isOk;
            }
        }
        if (this.formulaStr.indexOf("()") > 0) {
            this.msg = "\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26()";
            isOk = false;
        }
        return isOk;
    }

    public boolean checkValid() {
        if (this.formulaStr == null || this.formulaStr.trim().length() <= 0) {
            this.msg = "\u8bf7\u8bbe\u7f6e\u5c5e\u6027calRule!";
            return false;
        }
        return this.compareToLR() && this.checkFormula();
    }

    public double getResult() {
        String mulastr = "";
        String calRule = "";
        double value = 0.0;
        calRule = this.formulaStr;
        if (this.checkValid()) {
            for (int i = 0; i < this.leftBracket; ++i) {
                int iStart = calRule.lastIndexOf("(") + 1;
                mulastr = calRule.substring(iStart, iStart + calRule.substring(iStart).indexOf(")")).trim();
                this.symbolParse(mulastr);
                value = this.parseString();
                iStart = calRule.lastIndexOf("(");
                int iEnd = calRule.substring(iStart).indexOf(")") + 1;
                calRule = calRule.substring(0, iStart).trim() + value + calRule.substring(iStart + iEnd, calRule.length()).trim();
            }
        }
        double tmp = Math.pow(10.0, 10.0);
        value = (double)Math.round(value * tmp) / tmp;
        LOG.info("\u95ee\u9898msg:{}", (Object)this.msg);
        return value;
    }

    public void formulaStr(String calRule) {
        String mulastrs = "";
        if (this.checkValid()) {
            for (int i = 0; i < this.leftBracket; ++i) {
                mulastrs = calRule.substring(calRule.lastIndexOf("(") + 1, calRule.indexOf(")")).trim();
                this.symbolParse(mulastrs);
                double value = this.parseString();
                LOG.info("formulaStr:{}", (Object)mulastrs);
                calRule = calRule.substring(0, calRule.lastIndexOf("(")).trim() + value + calRule.substring(calRule.indexOf(")") + 1, calRule.length()).trim();
                LOG.info("calRule={}", (Object)calRule);
            }
        }
    }

    private void symbolParse(String str) {
        this.list.clear();
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            this.compareMin(str);
            while (this.sym[i] != -1) {
                String insStr = str.substring(0, this.sym[i]).trim();
                if (this.containsLetter(insStr)) {
                    insStr = Integer.toString(this.parseLetter(insStr, paras.get(count)));
                }
                this.list.add(insStr);
                insStr = str.substring(this.sym[i], this.sym[i] + 1).trim();
                this.list.add(insStr);
                str = str.substring(this.sym[i] + 1, str.length()).trim();
                this.compareMin(str);
                ++count;
            }
        }
        if (this.sym[0] == -1 && this.sym[1] == -1 && this.sym[2] == -1 && this.sym[3] == -1) {
            if (this.containsLetter(str)) {
                str = Integer.toString(this.parseLetter(str, paras.get(count)));
            }
            this.list.add(str);
        }
    }

    public boolean containsLetter(String insStr) {
        boolean isLetter = false;
        for (int i = 0; i < insStr.length(); ++i) {
            char ch = insStr.charAt(i);
            if (!Character.isLetter(ch)) continue;
            isLetter = true;
        }
        return isLetter;
    }

    public int parseLetter(String insStr, int para) {
        if (insStr.charAt(0) == '-') {
            para = 0 - para;
        }
        return para;
    }

    private void compareMin(String str) {
        int spm;
        int spd;
        int spa;
        int sps;
        this.sym[0] = sps = str.indexOf("`");
        this.sym[1] = spa = str.indexOf("+");
        this.sym[2] = spd = str.indexOf("/");
        this.sym[3] = spm = str.indexOf("*");
        for (int i = 1; i < this.sym.length; ++i) {
            for (int j = 0; j < this.sym.length - i; ++j) {
                if (this.sym[j] <= this.sym[j + 1]) continue;
                int temp = this.sym[j];
                this.sym[j] = this.sym[j + 1];
                this.sym[j + 1] = temp;
            }
        }
    }

    private double parseString() throws NumberFormatException, StringIndexOutOfBoundsException {
        try {
            this.calculate();
            return this.answer;
        }
        catch (Exception e) {
            this.msg = "\u9519\u8bef\uff1a" + e.getMessage();
            return 0.0;
        }
    }

    private void calculate() {
        int spd = this.list.indexOf("/");
        while (spd != -1) {
            this.leftNumber = this.list.get(spd - 1);
            this.rightNumber = this.list.get(spd + 1);
            this.list.remove(spd - 1);
            this.list.remove(spd - 1);
            this.list.remove(spd - 1);
            double ln = Double.valueOf(this.leftNumber);
            double rn = Double.valueOf(this.rightNumber);
            double answerres = ln / rn;
            this.list.add(spd - 1, String.valueOf(answerres));
            spd = this.list.indexOf("/");
        }
        int spm = this.list.indexOf("*");
        while (spm != -1) {
            this.leftNumber = this.list.get(spm - 1);
            this.rightNumber = this.list.get(spm + 1);
            this.list.remove(spm - 1);
            this.list.remove(spm - 1);
            this.list.remove(spm - 1);
            double ln = Double.valueOf(this.leftNumber);
            double rn = Double.valueOf(this.rightNumber);
            double answers = ln * rn;
            this.list.add(spm - 1, String.valueOf(answers));
            spm = this.list.indexOf("*");
        }
        int sps = this.list.indexOf("`");
        while (sps != -1) {
            this.leftNumber = this.list.get(sps - 1);
            this.rightNumber = this.list.get(sps + 1);
            this.list.remove(sps - 1);
            this.list.remove(sps - 1);
            this.list.remove(sps - 1);
            double ln = Double.valueOf(this.leftNumber);
            double rn = Double.valueOf(this.rightNumber);
            double answerRes = ln - rn;
            this.list.add(sps - 1, String.valueOf(answerRes));
            sps = this.list.indexOf("`");
        }
        int spa = this.list.indexOf("+");
        while (spa != -1) {
            this.leftNumber = this.list.get(spa - 1);
            this.rightNumber = this.list.get(spa + 1);
            this.list.remove(spa - 1);
            this.list.remove(spa - 1);
            this.list.remove(spa - 1);
            double ln = Double.valueOf(this.leftNumber);
            double rn = Double.valueOf(this.rightNumber);
            double answerRes = ln + rn;
            this.list.add(spa - 1, String.valueOf(answerRes));
            spa = this.list.indexOf("+");
        }
        if (!this.list.isEmpty()) {
            this.answer = Double.parseDouble(this.list.get(0));
        }
    }
}

