/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import com.alibaba.dubbo.rpc.RpcContext;
import com.aliyun.openservices.ons.api.Message;
import com.cgd.base.mq.MqCunsumer;
import com.cgd.base.mq.MqProducerPool;
import com.cgd.base.util.AOPErrorLogger;
import com.cgd.base.util.AOPLogger;
import com.cgd.base.util.AtomServiceAopErrorLogger;
import com.cgd.base.util.AtomServiceAopLogger;
import com.cgd.base.util.BusiErrorLogger;
import com.cgd.base.util.BusiLogger;
import com.cgd.base.util.MQErrorLogger;
import com.cgd.base.util.MQLogger;
import com.cgd.base.util.ThrowableInfoUtils;
import com.cgd.base.util.TimedTaskAopErrorLogger;
import com.cgd.base.util.TimedTaskAopLogger;
import com.cgd.base.util.XmlManageDom4jUtils;
import com.cgd.common.exception.ResourceException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.eagleeye.EagleEye;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger aotmLog = LoggerFactory.getLogger(AtomServiceAopLogger.class);
    private static final Logger aotmErrorLog = LoggerFactory.getLogger(AtomServiceAopErrorLogger.class);
    private static final Logger busilog = LoggerFactory.getLogger(BusiLogger.class);
    private static final Logger busiErrorLog = LoggerFactory.getLogger(BusiErrorLogger.class);
    private static final Logger aoplog = LoggerFactory.getLogger(AOPLogger.class);
    private static final Logger aopErrorLog = LoggerFactory.getLogger(AOPErrorLogger.class);
    private static final Logger mqlog = LoggerFactory.getLogger(MQLogger.class);
    private static final Logger mqErrorLog = LoggerFactory.getLogger(MQErrorLogger.class);
    private static final Logger timedLog = LoggerFactory.getLogger(TimedTaskAopLogger.class);
    private static final Logger timedErrorLog = LoggerFactory.getLogger(TimedTaskAopErrorLogger.class);
    private static final String SEPARATOR = "|";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "1";
    private static final String END_IDENTIFICATION = "2";
    private static final String ERROR_IDENTIFICATION = "0";
    private static final String MQPRODUCER = "1";
    private static final String MQCONSUMER = "2";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Map<Object, String[]> classNameMap = new HashMap<Object, String[]>();
    private static final String CONSUMER_METHOD_NAME = "execute";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final Properties props = new Properties();
    public static final String JSON_TRANS_ERROR = "\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5";

    private LogUtils() {
        throw new UnsupportedOperationException("\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static final String[] printAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        Long nowTime = System.currentTimeMillis();
        String[] infos = new String[16];
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            infos[4] = "";
            commonHead.append(SEPARATOR);
            try {
                infos[5] = mapper.writeValueAsString(params[0]);
            }
            catch (JsonProcessingException e) {
                infos[5] = (JSON_TRANS_ERROR + params[0]).replace("\r\n", "");
            }
            infos[6] = "";
            infos[7] = "";
        }
        aoplog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printAopErrorLog(String[] infos, String keyWord, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        infos[4] = keyWord;
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[6] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        aopErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printAopEndLog(String[] infos) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = "2";
        infos[3] = nowTime.toString();
        aoplog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static final void printMQProducerLog(String className, String method, Message msg, Object body) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(LogUtils.getTraceId() + SEPARATOR);
        commonHead.append(msg.getMsgID());
        commonHead.append(SEPARATOR);
        String[] infos = new String[9];
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(method);
        commonHead.append(SEPARATOR);
        commonHead.append("1");
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = infos[2];
        infos[5] = msg.getTopic();
        infos[4] = MqProducerPool.producerIds.get(infos[5]);
        infos[6] = msg.getTag();
        infos[7] = msg.getKey();
        try {
            infos[8] = mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            infos[8] = (JSON_TRANS_ERROR + body).replace("\r\n", "");
        }
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printMQErrorLog(String className, String method, Message msg, Object body, Throwable e) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(LogUtils.getTraceId() + SEPARATOR);
        commonHead.append(msg.getMsgID());
        commonHead.append(SEPARATOR);
        String[] infos = new String[10];
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(method);
        commonHead.append(SEPARATOR);
        commonHead.append("1");
        infos[0] = commonHead.toString();
        infos[1] = ERROR_IDENTIFICATION;
        infos[2] = nowTime.toString();
        infos[3] = infos[2];
        infos[5] = msg.getTopic();
        infos[4] = MqProducerPool.producerIds.get(infos[5]);
        infos[6] = msg.getTag();
        infos[7] = msg.getKey();
        try {
            infos[8] = mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException ex) {
            infos[8] = (JSON_TRANS_ERROR + body).replace("\r\n", "");
        }
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[9] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        mqErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static final String[] printMQConsumerStartLog(Message msg, MqCunsumer consumer) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(LogUtils.getTraceId() + SEPARATOR);
        commonHead.append(msg.getMsgID());
        commonHead.append(SEPARATOR);
        String[] infos = new String[9];
        String[] consumerInfos = classNameMap.get(consumer);
        if (consumerInfos == null) {
            consumerInfos = new String[2];
            String className = null;
            className = Proxy.isProxyClass(consumer.getClass()) ? Proxy.getInvocationHandler(consumer).getClass().getName() : consumer.getClass().getName();
            consumerInfos[0] = className;
            consumerInfos[1] = props.getProperty(consumer.subscribe().getConsumerId());
            classNameMap.put(consumer, consumerInfos);
        }
        commonHead.append(consumerInfos[0]);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(CONSUMER_METHOD_NAME);
        commonHead.append(SEPARATOR);
        commonHead.append("2");
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = "";
        infos[4] = consumerInfos[1];
        infos[5] = msg.getTopic();
        infos[6] = msg.getTag();
        infos[7] = msg.getKey();
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printMQConsumerEndLog(String[] infos) {
        Long nowTime = System.currentTimeMillis();
        infos[1] = "2";
        infos[3] = nowTime.toString();
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printMQConsumerErrorLog(String[] infos, Throwable e) {
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[9] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static final String[] printBusiAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[6];
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = (JSON_TRANS_ERROR + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        busilog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printBusiAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[5] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        busiErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printBusiAopEndLog(String[] infos) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = "2";
        infos[3] = nowTime.toString();
        busilog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static final String[] printAtomServiceAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[6];
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = (JSON_TRANS_ERROR + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = (JSON_TRANS_ERROR + obj).replace("\r\n", "");
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
                infos[4] = paramsStr.toString();
            }
        }
        aotmLog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printAtomServiceAopEndLog(String[] infos) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = "2";
        infos[3] = nowTime.toString();
        aotmLog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printAtomAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[5] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        aotmErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    private static final String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info + SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private static final String getTraceId() {
        String traceId = "";
        Map hiddenParm = RpcContext.getContext().getAttachments();
        traceId = hiddenParm.containsKey("traceId") ? (String)hiddenParm.get("traceId") : EagleEye.getTraceId();
        return traceId;
    }

    public static final String[] printTimedTaskAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[6];
        infos[0] = commonHead.toString();
        infos[1] = "1";
        infos[2] = nowTime.toString();
        infos[3] = "";
        timedLog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printTimedTaskAopEndLog(String[] infos) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = "2";
        infos[3] = nowTime.toString();
        timedLog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printTimedTaskAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (null != ThrowableInfoUtils.getThrowableStrRep(e)) {
            infos[5] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        }
        timedErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    static {
        try (InputStream ins = XmlManageDom4jUtils.class.getClassLoader().getResourceAsStream("env.properties");){
            props.load(ins);
        }
        catch (IOException e) {
            throw new ResourceException("8888", "\u52a0\u8f7d\u5168\u5c40\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }
}

