/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Method getDeclaredMethod(Object object, String methodName) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                method = m;
                break;
            }
            if (method != null) break;
        }
        return method;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        if (null != method && method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            if (null != method) {
                Object obj = method.invoke(object, parameters);
                if (method.isAccessible()) {
                    method.setAccessible(false);
                }
                return obj;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-invokeMethod]-IllegalArgumentException\u5f02\u5e38", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-invokeMethod]-InvocationTargetException\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        try {
            if (field != null) {
                field.setAccessible(true);
                field.set(object, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-setFieldValue]-IllegalArgumentException\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        try {
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (Exception e) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-getFieldValue]-IllegalAccessException\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

