/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionChannelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionChannelUtil.class);
    Session session = null;
    ChannelSftp channelSftp = null;
    ChannelExec channelExec = null;

    public Session sessionConnect(String username, String host, int port, String password, int timeout) throws JSchException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sessionConnect username:{}, host:{}, port:{}, password:{}, timeout:{}", new Object[]{username, host, port, password, timeout});
        }
        JSch jsch = new JSch();
        this.session = port <= 0 ? jsch.getSession(username, host) : jsch.getSession(username, host, port);
        this.session.setPassword(password);
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.connect();
        return this.session;
    }

    public ChannelSftp channelSftpConnect(Session session, int timeout) throws JSchException {
        this.channelSftp = (ChannelSftp)session.openChannel("sftp");
        this.channelSftp.connect(timeout);
        return this.channelSftp;
    }

    public ChannelExec channelExecConnect(Session session, String command, int timeout) throws JSchException {
        this.channelExec = (ChannelExec)session.openChannel("exec");
        this.channelExec.setCommand(command);
        this.channelExec.setInputStream(null);
        this.channelExec.connect(timeout);
        return this.channelExec;
    }

    public void closeSession() {
        if (this.channelSftp != null) {
            this.channelSftp.disconnect();
        }
        if (this.channelExec != null) {
            this.channelExec.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public void closeChannelSftp() {
        if (this.channelSftp != null) {
            this.channelSftp.disconnect();
        }
    }

    public void closeChannelExec() {
        if (this.channelExec != null) {
            this.channelExec.disconnect();
        }
    }
}

