/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util.http;

import com.cgd.base.util.http.HSNHttpPoolHelper;
import com.cgd.base.util.http.HttpRetBean;
import com.cgd.common.exception.BusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSHttpHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HSHttpHelper.class);

    private HSHttpHelper() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static HttpRetBean doUrlPostRequest(URI uri, Header[] headers, byte[] reqBody, String hpartyEnconding, Boolean isHttps) throws IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpPost(uri), headers, reqBody, hpartyEnconding, isHttps);
    }

    public static HttpRetBean doUrlGetRequest(URI uri, Header[] headers, String hpartyEnconding, Boolean isHttps) throws IOException, URISyntaxException {
        return HSHttpHelper.doUrlExecuteRequest((HttpUriRequest)new HttpGet(uri), headers, null, hpartyEnconding, isHttps);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpRetBean doUrlExecuteRequest(HttpUriRequest request, Header[] headers, byte[] reqBody, String hpartyEnconding, Boolean isHttps) throws IOException, URISyntaxException {
        HttpRetBean httpRetBean;
        if (headers != null && headers.length > 0) {
            request.setHeaders(headers);
        }
        if (reqBody != null && request instanceof HttpEntityEnclosingRequestBase) {
            ByteArrayEntity entity = new ByteArrayEntity(reqBody);
            entity.setChunked(false);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        HttpClient httpClient = null;
        ObjectPool httpClientPool = null;
        try {
            httpClientPool = Boolean.TRUE.equals(isHttps) ? HSNHttpPoolHelper.hsnHttpsObjectPoolBean.getHttpClientPool() : HSNHttpPoolHelper.hsnHttpObjectPoolBean.getHttpClientPool();
            httpClient = (HttpClient)httpClientPool.borrowObject();
            HttpResponse httpResponse = httpClient.execute(request);
            String returnData = null;
            InputStream inputStream = httpResponse.getEntity().getContent();
            returnData = inputStream == null ? null : IOUtils.toString((InputStream)inputStream, (String)hpartyEnconding);
            if (inputStream != null) {
                inputStream.close();
            }
            httpRetBean = new HttpRetBean(httpResponse.getStatusLine().getStatusCode(), httpResponse.getAllHeaders(), returnData);
            if (httpClient == null) return httpRetBean;
        }
        catch (IOException e) {
            try {
                request.abort();
                throw new IOException("IO exception:", e);
                catch (URISyntaxException e2) {
                    request.abort();
                    throw new URISyntaxException("url valid error:", e2.getMessage());
                }
                catch (Exception e3) {
                    throw new BusinessException("8888", request.getURI().toString() + ":" + e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                if (httpClient == null) throw throwable;
                try {
                    httpClientPool.returnObject(httpClient);
                    throw throwable;
                }
                catch (Exception e4) {
                    LOG.warn("HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)e4);
                }
                throw throwable;
            }
        }
        try {
            httpClientPool.returnObject((Object)httpClient);
            return httpRetBean;
        }
        catch (Exception e) {
            LOG.warn("HttpClient\u5bf9\u8c61\u5f52\u8fd8\u5931\u8d25", (Throwable)e);
        }
        return httpRetBean;
    }
}

