/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YEAR_24H_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static Date strToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static Date strToDateLong(String strDate) {
        return DateUtil.strToDateLong(strDate, YEAR_24H_FORMAT);
    }

    public static Date strToDateLong(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static Date strToDateyyyyMMddHHmmss(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static String dateToStrLong(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YEAR_24H_FORMAT);
        return formatter.format(date);
    }

    public static String dateToStrYYYYMMdd(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format(date);
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        return formatter.format(date);
    }

    public static String dateToMonthDay(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd");
        return formatter.format(date);
    }

    public static Date strToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static String getTimeShort() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String dateToStr(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static String strTostr(String str, String newPattern, String oldPattern) {
        Date date = DateUtil.strToDate(str, oldPattern);
        return DateUtil.dateToStr(date, newPattern);
    }

    public static Date getDate(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (days != null) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static boolean isValidDate(String dateStr, String datePattern) {
        if (StringUtils.isBlank((CharSequence)dateStr) || StringUtils.isBlank((CharSequence)datePattern)) {
            return false;
        }
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat(datePattern);
        try {
            format.setLenient(false);
            format.parse(dateStr);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static String getCurrentMaxDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(date, pos);
        return formatter.format(strtodate) + " 23:59:59";
    }

    public static String getCurrentMinDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYY_MM_DD);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(date, pos);
        return formatter.format(strtodate) + " 00:00:00";
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }
}

