/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.feature.orm.mybatis;

import com.alibaba.fastjson.JSON;
import com.cgd.common.cache.service.CacheService;
import com.cgd.feature.orm.mybatis.EncryTable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEncryInit {
    private static final Logger LOG = LoggerFactory.getLogger(DataEncryInit.class);
    private DataSource datasource;
    private CacheService cacheService;
    private String sysVersion;
    private String sysApp;

    public String getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(String sysVersion) {
        this.sysVersion = sysVersion;
    }

    public String getSysApp() {
        return this.sysApp;
    }

    public void setSysApp(String sysApp) {
        this.sysApp = sysApp;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataEncryInit() {
        LOG.info("DataEncryInit init");
    }

    public synchronized void init() throws SQLException {
        HashMap tableColumnMapping = new HashMap();
        LinkedList<String> interceptorMapping = new LinkedList<String>();
        try (Connection conn = this.datasource.getConnection();
             Statement stmt = conn.createStatement();){
            List<EncryTable> columns = DataEncryInit.getEncryTables(stmt);
            for (EncryTable table : columns) {
                if (table.getIsWild() == 1) {
                    try (ResultSet rs = stmt.executeQuery("show columns from " + table.gettName());){
                        ArrayList<String> columnList = new ArrayList<String>();
                        tableColumnMapping.put(table.gettName(), columnList);
                        while (rs.next()) {
                            columnList.add(rs.getString(1));
                        }
                    }
                }
                for (String str : table.gettColumns()) {
                    interceptorMapping.add(table.gettName() + ":" + str);
                }
            }
            String tableColumn = JSON.toJSONString(tableColumnMapping);
            String interceptorJson = JSON.toJSONString(interceptorMapping);
            LOG.info("tableColumnMapping:{},interceptorJson:{}", (Object)tableColumn, (Object)interceptorJson);
        }
        catch (Exception e) {
            LOG.error("init exception", (Throwable)e);
            throw e;
        }
    }

    private static List<EncryTable> getEncryTables(Statement stmt) throws SQLException {
        ArrayList<EncryTable> columns = new ArrayList<EncryTable>();
        try (ResultSet rs = stmt.executeQuery("select t_name,t_columns,is_wild from t_encry_table");){
            while (rs.next()) {
                EncryTable encryTable = new EncryTable();
                encryTable.settName(rs.getString(1));
                String tColumn = rs.getString(2);
                String[] str = tColumn.split(",");
                ArrayList<String> columnList = new ArrayList<String>(Arrays.asList(str));
                encryTable.settColumns(columnList);
                encryTable.setIsWild(rs.getInt(3));
                columns.add(encryTable);
            }
        }
        return columns;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

