/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.feature.orm.mybatis;

import com.alibaba.druid.util.StringUtils;
import com.cgd.feature.orm.mybatis.enchance.AesUtils;
import com.cgd.feature.orm.mybatis.enchance.EnhanceColumn;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BeanWrapper;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetHandlerInterceptor
implements Interceptor {
    private static final ThreadLocal<Map<String, EnhanceColumn>> SELECT_COLUMN_MAPPING = new ThreadLocal();
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory REFLECTOR_FACTORY = new DefaultReflectorFactory();

    public static final void setSelectColumnMapping(Map<String, EnhanceColumn> selectColumnMapping) {
        SELECT_COLUMN_MAPPING.set(selectColumnMapping);
    }

    public static final Map<String, EnhanceColumn> getSelectColumnMapping() {
        return SELECT_COLUMN_MAPPING.get();
    }

    public static final void deleteSelectColumnMapping() {
        SELECT_COLUMN_MAPPING.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object dbObj;
        block8: {
            try {
                dbObj = invocation.proceed();
                Map<String, EnhanceColumn> selectColumnMapping = ResultSetHandlerInterceptor.getSelectColumnMapping();
                if (selectColumnMapping == null || selectColumnMapping.isEmpty() || !Collection.class.isInstance(dbObj)) break block8;
                Collection queryResults = (Collection)dbObj;
                Iterator resultSets = queryResults.iterator();
                while (resultSets.hasNext()) {
                    HashSet<String> processedColumns = new HashSet<String>();
                    Object obj = resultSets.next();
                    MetaObject metaReturnItem = MetaObject.forObject(obj, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
                    for (EnhanceColumn enhanceColumn : selectColumnMapping.values()) {
                        if (!enhanceColumn.isNeedEncode() || processedColumns.contains(enhanceColumn.uniqueKey())) continue;
                        if (enhanceColumn.getParentProperty() != null) {
                            MetaObject parentMetaObject = metaReturnItem.metaObjectForProperty(enhanceColumn.getParentProperty());
                            if (Collection.class.isAssignableFrom(enhanceColumn.getParentPropertyType())) {
                                List d = (List)metaReturnItem.getValue(enhanceColumn.getParentProperty());
                                BeanWrapper beanWrapper = new BeanWrapper(parentMetaObject, (Object)d);
                                for (int i = 0; i < d.size(); ++i) {
                                    String index = "[" + i + "]";
                                    Object children = beanWrapper.get(new PropertyTokenizer(index));
                                    MetaObject mi = MetaObject.forObject((Object)children, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)REFLECTOR_FACTORY);
                                    Object miValue = mi.getValue(enhanceColumn.getProperty());
                                    if (!(miValue instanceof String)) continue;
                                    mi.setValue(enhanceColumn.getProperty(), (Object)AesUtils.decrypt((String)miValue, AesUtils.getPrivateKey(null)));
                                }
                                continue;
                            }
                            Object fieldValue = parentMetaObject.getValue(enhanceColumn.getProperty());
                            processedColumns.add(enhanceColumn.uniqueKey());
                            if (!(fieldValue instanceof String)) continue;
                            parentMetaObject.setValue(enhanceColumn.getProperty(), (Object)AesUtils.decrypt((String)fieldValue, AesUtils.getPrivateKey(null)));
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)enhanceColumn.getProperty())) continue;
                        Object fieldValue = metaReturnItem.getValue(enhanceColumn.getProperty());
                        processedColumns.add(enhanceColumn.uniqueKey());
                        if (!(fieldValue instanceof String)) continue;
                        metaReturnItem.setValue(enhanceColumn.getProperty(), (Object)AesUtils.decrypt((String)fieldValue, AesUtils.getPrivateKey(null)));
                    }
                }
            }
            finally {
                ResultSetHandlerInterceptor.deleteSelectColumnMapping();
            }
        }
        return dbObj;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

