/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.feature.orm.mybatis.enchance;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class AesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AesUtils.class);
    private static final String DEFAULT_ENC_KEY = "passwd";
    private static final String KEY_ALGORITHM = "AES";
    private static final String SECRET_RANDOM = "SHA1PRNG";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String SPLIT_ORGIN = "0X01,";

    private AesUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static final String getPrivateKey(String bizCode) {
        LOG.debug("bizCode={}", (Object)bizCode);
        return DEFAULT_ENC_KEY;
    }

    public static String encrypt(String content, String password) {
        if (StringUtils.isEmpty((Object)content)) {
            return content;
        }
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, AesUtils.getSecretKey(password));
            byte[] result = cipher.doFinal(byteContent);
            String bae = Base64Utils.encodeToString((byte[])result);
            return SPLIT_ORGIN + bae;
        }
        catch (Exception e) {
            throw new RuntimeException("do encrypt error", e);
        }
    }

    public static String decrypt(String content, String password) {
        if (StringUtils.isEmpty((Object)content)) {
            return content;
        }
        if (content.indexOf(SPLIT_ORGIN) != 0) {
            return content;
        }
        content = content.split(SPLIT_ORGIN)[1];
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AesUtils.getSecretKey(password));
            byte[] result = cipher.doFinal(Base64Utils.decodeFromString((String)content));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("do decrypt error", e);
        }
    }

    private static SecretKeySpec getSecretKey(String password) {
        byte[] keyBytes = Arrays.copyOf(password.getBytes(StandardCharsets.US_ASCII), 16);
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }
}

