/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.cgd.base.util.LogUtils;
import com.cgd.common.annotation.BusiRequest;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.cache.service.CacheExecuterService;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusinessException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class BusiAopAdvisor
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(BusiAopAdvisor.class);
    public static final String RESP_CODE = "respCode";
    public static final String RESP_DESC = "respDesc";
    public static final String INNER_CODE = "innerCode";
    public static final String INNER_CODE_DESC = "innerCodeDesc";
    private CacheExecuterService<Map<String, String>> exceptionInfoService;
    private CacheService cacheService;

    public int getOrder() {
        return 0;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        RpcContext rpcContext = RpcContext.getContext();
        Map hiddenParm = rpcContext.getAttachments();
        String traceId = "";
        traceId = this.getTraceId(hiddenParm, traceId);
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        String[] infos = LogUtils.printBusiAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            LOG.error("throwAopTreat:" + e.getMessage(), (Throwable)e);
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            msgCode = this.getMsgCode(e, msgCode);
            LogUtils.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            LOG.error("\u7cfb\u7edf\u5f02\u5e38  ", e);
            rspObj = rspClass.newInstance();
            LogUtils.printBusiAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25");
        }
        LogUtils.printBusiAopEndLog(infos);
        return rspObj;
    }

    private String getMsgCode(BusinessException e, String msgCode) {
        if (msgCode != null && !"".equals(msgCode)) {
            Map<String, String> innerCodeMap = this.cacheService.getInnerCodeByKey(this.exceptionInfoService, msgCode);
            String string = msgCode = innerCodeMap.get(INNER_CODE) == null ? e.getMsgCode() : innerCodeMap.get(INNER_CODE);
        }
        if (msgCode == null || "".equals(msgCode)) {
            if (e.getCause() instanceof BusinessException) {
                msgCode = e.getMsgCode();
            }
            if (msgCode == null || "".equals(msgCode)) {
                msgCode = "8888";
            }
        }
        return msgCode;
    }

    private String getTraceId(Map<String, String> hiddenParm, String traceId) {
        if (hiddenParm.containsKey("traceId")) {
            traceId = hiddenParm.get("traceId");
        } else {
            hiddenParm.put("traceId", traceId);
        }
        return traceId;
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        LOG.debug("fource:{}", (Object)fource);
        if (object instanceof RspBusiBaseBO) {
            field = RspBusiBaseBO.class.getDeclaredField(RESP_CODE);
            field.setAccessible(true);
            if (field.get(object) == null) {
                BusiAopAdvisor.feildRspBusiBaseBOSet(object, code, desc, field);
            }
        }
        if (object instanceof RspInfoBO) {
            field = RspInfoBO.class.getDeclaredField(RESP_CODE);
            field.setAccessible(true);
            if (field.get(object) == null) {
                BusiAopAdvisor.fieldRspInfoSet(object, code, desc, field);
            }
        }
    }

    private static void fieldRspInfoSet(Object object, String code, String desc, Field field) throws IllegalAccessException, NoSuchFieldException {
        field.set(object, code);
        field = RspInfoBO.class.getDeclaredField(RESP_DESC);
        field.setAccessible(true);
        field.set(object, desc);
    }

    private static void feildRspBusiBaseBOSet(Object object, String code, String desc, Field field) throws IllegalAccessException, NoSuchFieldException {
        field.set(object, code);
        field = RspBusiBaseBO.class.getDeclaredField(RESP_DESC);
        field.setAccessible(true);
        field.set(object, desc);
    }

    public Object bulidRspObj(BusiRequest br, Class<?> resClass) throws Exception {
        Object rspObj = null;
        String key = br.key();
        String desc = br.desc();
        Map<String, String> innerCodeMap = this.cacheService.getInnerCodeByKey(this.exceptionInfoService, key);
        key = innerCodeMap.get(INNER_CODE) == null ? key : innerCodeMap.get(INNER_CODE);
        desc = innerCodeMap.get(INNER_CODE_DESC) == null || "".equals(innerCodeMap.get(INNER_CODE_DESC)) ? desc : innerCodeMap.get(INNER_CODE_DESC);
        rspObj = resClass.newInstance();
        this.putCodeToRsp(rspObj, key, desc);
        return rspObj;
    }

    public void put(String key, String value, Map<String, String> hiddenParm) {
        hiddenParm.computeIfAbsent(key, k -> value);
    }

    public void setExceptionInfoService(CacheExecuterService<Map<String, String>> exceptionInfoService) {
        this.exceptionInfoService = exceptionInfoService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

