/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.cache;

import com.cgd.base.cache.CacheManager;
import com.cgd.base.cache.CacheServiceImpl;
import com.cgd.base.cache.redis.RedisClusterManager;
import com.cgd.base.cache.redis.RedisManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class CacheRedisConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CacheRedisConfig.class);
    private String host = "127.0.0.1";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "";

    public RedisClusterManager redisClusterManager() {
        RedisClusterManager manager = new RedisClusterManager();
        manager.setHost(this.host);
        manager.setPwd(this.password);
        manager.setTimeout(this.timeout);
        manager.setExpire(0);
        manager.setMaxAttemts(3);
        manager.setSoTimeOut(this.timeout);
        manager.setExpire(0);
        manager.init();
        return manager;
    }

    public RedisManager redisManager() {
        RedisManager manager = new RedisManager();
        manager.setHost(this.host);
        manager.setPassword(this.password);
        manager.setTimeout(this.timeout);
        manager.setExpire(this.expire);
        manager.init();
        return manager;
    }

    @Bean
    @Primary
    public CacheManager cacheManager() {
        CacheManager cacheManager = null;
        if (this.host.indexOf(",") > -1) {
            LOG.info("redis-cluster \u542f\u52a8");
            cacheManager = this.redisClusterManager();
        } else {
            LOG.info("redis \u5355\u673a\u542f\u52a8");
            cacheManager = this.redisManager();
        }
        return cacheManager;
    }

    @Bean
    @Primary
    public CacheServiceImpl cacheServiceImpl() {
        CacheServiceImpl cacheServiceImpl = new CacheServiceImpl();
        cacheServiceImpl.setCacheManager(this.cacheManager());
        return cacheServiceImpl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

