/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.file;

import com.cgd.base.file.ftp.FtpConfig;
import com.cgd.base.file.ftp.FtpUtil;
import com.cgd.base.file.minio.MinioConfig;
import com.cgd.base.file.minio.MinioUtil;
import com.cgd.base.file.oss.OssConfig;
import com.cgd.base.file.oss.OssUtil;
import com.cgd.common.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(FileProcessing.class);
    public static final String URL_PATH_LINE = "/";
    private static final Integer DEFALT_PORT = -1;
    public static final String MINIO = "MINIO";
    public static final String OSS = "OSS";
    private static Properties prop;
    private static String fileHost;
    private static String fileUser;
    private static String filePwd;
    private static Integer filePort;
    private static Integer timeOut;
    private static String sysFtpRootPath;
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String minioEndPoint;
    private static String minioAccessKeyId;
    private static String minioAccessKeySecret;
    private static String minioBucketName;
    private static String accessUrl;
    private static String fileSystem;
    private static FtpConfig ftpConfig;
    private static OssConfig ossConfig;
    private static MinioConfig minioConfig;
    private static String esbFtpUpload;
    private static String esbFtpDowload;

    public synchronized void setProp(Properties prop) {
        FileProcessing.prop = prop;
        fileHost = prop.getProperty("FILE_HOST");
        fileUser = prop.getProperty("FILE_USER");
        filePwd = prop.getProperty("FILE_PWD");
        filePort = Integer.parseInt(prop.getProperty("FILE_PORT"));
        timeOut = Integer.parseInt(prop.getProperty("TIME_OUT"));
        sysFtpRootPath = prop.getProperty("FILE_UPLOAD_PATH");
        endpoint = prop.getProperty("OSS_ENDPOINT");
        accessKeyId = prop.getProperty("OSS_ACCESSKEY");
        accessKeySecret = prop.getProperty("OSS_ACCESSKEY_SECRET");
        fileSystem = prop.getProperty("OSS_TYPE");
        bucketName = prop.getProperty("OSS_BUCKETNAME");
        accessUrl = MINIO.equals(fileSystem) ? prop.getProperty("minio.accessurl") : prop.getProperty("OSS_ACCESS_URL");
        minioEndPoint = prop.getProperty("minio.endPoint");
        minioAccessKeyId = prop.getProperty("minio.accessKeyId");
        minioAccessKeySecret = prop.getProperty("minio.accessKeySecret");
        minioBucketName = prop.getProperty("minio.bucketName");
        this.setFileSystemConfig();
        esbFtpUpload = prop.getProperty("ESB_FTP_UPLOAD");
        esbFtpDowload = prop.getProperty("ESB_FTP_DOWLOAD");
    }

    private void setFileSystemConfig() {
        switch (fileSystem) {
            case "MINIO": {
                minioConfig = new MinioConfig(minioEndPoint, minioAccessKeyId, minioAccessKeySecret, minioBucketName, accessUrl);
                break;
            }
            case "OSS": {
                ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
                break;
            }
            default: {
                ftpConfig = new FtpConfig(fileHost, fileUser, filePwd, filePort, timeOut);
            }
        }
    }

    public static File downloadFile(String fileName, String sysCenter, String businessType) {
        switch (fileSystem) {
            case "MINIO": {
                return MinioUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, minioConfig);
            }
            case "OSS": {
                return OssUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig);
            }
        }
        return FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
    }

    public static File downloadFileNew(String name, String fileName, String sysCenter, String businessType) {
        switch (fileSystem) {
            case "MINIO": {
                return MinioUtil.downloadFileNewName(name, FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, minioConfig);
            }
            case "OSS": {
                return OssUtil.downloadFileNewName(name, FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig);
            }
        }
        return FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
    }

    private static String getSysFileServicePath(String sysCenter, String businessType) {
        if ("COMMODITY".equals(sysCenter)) {
            return prop.getProperty("FILE_COMMODITY_PATH").trim();
        }
        if ("PAY".equals(sysCenter)) {
            return prop.getProperty("FILE_PAY_PATH").trim();
        }
        return prop.getProperty("FILE_UPLOAD_PATH").trim();
    }

    public static String upLoadFile(File file, String businessType, String sysCenter, boolean isNeedNewName) {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        switch (fileSystem) {
            case "MINIO": {
                MinioUtil.uploadFile(file, minioConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                break;
            }
            case "OSS": {
                OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                break;
            }
            default: {
                FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
            }
        }
        return fileName;
    }

    public static String upLoadFileResponsePath(File file, String businessType, String sysCenter, boolean isNeedNewName) {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        switch (fileSystem) {
            case "MINIO": {
                MinioUtil.uploadFile(file, minioConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                fileName = accessUrl + URL_PATH_LINE + FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName;
                break;
            }
            case "OSS": {
                OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                fileName = accessUrl + URL_PATH_LINE + FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName;
                break;
            }
            default: {
                FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
            }
        }
        return fileName;
    }

    public static void upLoadFileToEsb(File file) {
        FtpUtil.uploadFile(file, ftpConfig, esbFtpUpload);
    }

    public static File downLoadFileFromEsb(String fileName) {
        return FtpUtil.downloadFile(esbFtpDowload + fileName, ftpConfig);
    }

    public static List<String> listFiles(String suffix) {
        return FtpUtil.listFiles(esbFtpDowload, suffix, ftpConfig);
    }

    public static String uploadFileByInputStream(String fileName, InputStream inputStream, String businessType, String sysCenter, boolean isNeedNewName) {
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        try {
            switch (fileSystem) {
                case "MINIO": {
                    MinioUtil.uploadFileByInputStream(fileName, minioConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                    fileName = accessUrl + URL_PATH_LINE + FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName;
                    break;
                }
                case "OSS": {
                    OssUtil.uploadFileByInputStream(fileName, ossConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                    fileName = accessUrl + URL_PATH_LINE + FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName;
                    break;
                }
                default: {
                    FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("uploaded file path:{}", (Object)fileName);
            }
        }
        catch (BusinessException e) {
            LOG.error("\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
            throw new BusinessException("8888", "\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u51fa\u9519\uff01");
        }
        return fileName;
    }

    public static void mergeFile(File file, InputStream is) {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));){
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.flush();
        }
        catch (IOException e) {
            LOG.error("\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            throw new BusinessException("8888", "\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u9519\u8bef");
        }
    }

    public static void deleteFile(String fileName, String sysCenter, String businessType) {
        switch (fileSystem) {
            case "MINIO": {
                MinioUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + URL_PATH_LINE + fileName, minioConfig);
                break;
            }
            case "OSS": {
                OssUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + URL_PATH_LINE + fileName, ossConfig);
                break;
            }
            default: {
                FtpUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + URL_PATH_LINE + fileName, ftpConfig);
            }
        }
    }

    public static BufferedInputStream getObject(String sysCenter, String businessType, String key) {
        return OssUtil.getObject(ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType) + key);
    }
}

