/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.IRowReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class Excel2003Reader<T>
implements HSSFListener {
    private int minColumns = -1;
    POIFSFileSystem fs;
    private int lastRowNumber;
    private int lastColumnNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private int sheetIndex = -1;
    private BoundSheetRecord[] orderedBSRs;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private int curRow = 0;
    private List<String> rowlist = new ArrayList<String>();
    private String sheetName;
    private IRowReader<T> rowReader;

    public void setRowReader(IRowReader<T> rowReader) {
        this.rowReader = rowReader;
    }

    public void process(String fileName) throws IOException {
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(fileName));
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        if (this.outputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        factory.processWorkbookEvents(request, this.fs);
    }

    public void processRecord(Record excelRecord) {
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        String value = null;
        switch (excelRecord.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)excelRecord);
                break;
            }
            case 2057: {
                this.stubWorksheetCrt((BOFRecord)excelRecord);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)excelRecord;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)excelRecord;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisStr = "";
                this.rowlist.add(thisColumn, thisStr);
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)excelRecord;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = berec.getBooleanValue() + "";
                this.rowlist.add(thisColumn, thisStr);
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)excelRecord;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                thisStr = this.dealFormulaRecord(frec, thisStr);
                this.rowlist.add(thisColumn, thisStr);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)excelRecord;
                this.curRow = thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                value = lrec.getValue().trim();
                value = value.equals("") ? " " : value;
                this.rowlist.add(thisColumn, value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)excelRecord;
                this.curRow = thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                this.dealRecordStr(thisColumn, lsrec);
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)excelRecord;
                this.curRow = thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                value = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec).trim();
                value = value.equals("") ? " " : value;
                this.rowlist.add(thisColumn, value);
                break;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (excelRecord instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)excelRecord;
            this.curRow = thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            this.rowlist.add(thisColumn, " ");
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        this.endCellOfRowDeal(excelRecord);
    }

    private void endCellOfRowDeal(Record lastRecord) {
        if (lastRecord instanceof LastCellOfRowDummyRecord) {
            if (this.minColumns > 0 && this.lastColumnNumber == -1) {
                this.lastColumnNumber = 0;
            }
            this.lastColumnNumber = -1;
            this.rowReader.setRows(this.sheetIndex, this.curRow, this.rowlist);
            this.rowlist.clear();
        }
    }

    private void dealRecordStr(int thisColumn, LabelSSTRecord lsrec) {
        if (this.sstRecord == null) {
            this.rowlist.add(thisColumn, " ");
        } else {
            String value = this.sstRecord.getString(lsrec.getSSTIndex()).toString().trim();
            value = value.equals("") ? " " : value;
            this.rowlist.add(thisColumn, value);
        }
    }

    private String dealFormulaRecord(FormulaRecord frec, String thisStr) {
        if (this.outputFormulaValues) {
            if (Double.isNaN(frec.getValue())) {
                this.outputNextStringRecord = true;
                this.nextRow = frec.getRow();
                this.nextColumn = frec.getColumn();
            } else {
                thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
            }
        } else {
            thisStr = '\"' + HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression()) + '\"';
        }
        return thisStr;
    }

    private void stubWorksheetCrt(BOFRecord br) {
        if (br.getType() == 16) {
            this.stubWorkbookIfCreate();
            ++this.sheetIndex;
            this.orderByBofPosition();
            this.sheetName = this.orderedBSRs[this.sheetIndex].getSheetname();
        }
    }

    private void orderByBofPosition() {
        if (this.orderedBSRs == null) {
            this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
        }
    }

    private void stubWorkbookIfCreate() {
        if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
            this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
        }
    }
}

