/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.cgd.base.fileanalyzing.IRowReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Excel2007Reader<T>
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Excel2007Reader.class);
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private int sheetIndex = -1;
    private List<String> rowlist = new ArrayList<String>();
    private int curRow = 0;
    private int curCol = 0;
    private boolean dateFlag;
    private boolean numberFlag;
    private boolean isTElement;
    private IRowReader<T> rowReader;
    private static final Integer NEW_SCALE = 3;

    public void setRowReader(IRowReader<T> rowReader) {
        this.rowReader = rowReader;
    }

    public void processOneSheet(String filename, int sheetId) throws OpenXML4JException, IOException, SAXException {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable ssTable = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(ssTable);
        InputStream sheet2 = r.getSheet("rId" + sheetId);
        ++this.sheetIndex;
        InputSource sheetSource = new InputSource(sheet2);
        parser.parse(sheetSource);
        sheet2.close();
    }

    public void process(String filename) throws OpenXML4JException, IOException, SAXException {
        OPCPackage pkg = OPCPackage.open((String)filename);
        XSSFReader r = new XSSFReader(pkg);
        SharedStringsTable ssTable = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(ssTable);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            this.curRow = 0;
            ++this.sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            this.nextIsString = "s".equals(cellType);
            String cellDateType = attributes.getValue("s");
            this.dateFlag = "1".equals(cellDateType);
            String cellNumberType = attributes.getValue("s");
            this.numberFlag = "2".equals(cellNumberType);
        }
        this.isTElement = "t".equals(name);
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception e) {
                LOG.error("[\u57fa\u7840\u7ec4\u4ef6-EXCEL-READER\u7ed3\u675f\u5143\u7d20\u5faa\u73af]-\u5f02\u5e38", (Throwable)e);
            }
        }
        if (this.isTElement) {
            String value = this.lastContents.trim();
            this.rowlist.add(this.curCol, value);
            ++this.curCol;
            this.isTElement = false;
        } else if ("v".equals(name)) {
            String value = this.lastContents.trim();
            String string = value = "".equals(value) ? " " : value;
            if (this.dateFlag) {
                Date date = HSSFDateUtil.getJavaDate((double)Double.valueOf(value));
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                value = dateFormat.format(date);
            }
            if (this.numberFlag) {
                BigDecimal bd = new BigDecimal(value);
                value = bd.setScale((int)NEW_SCALE, 0).toString();
            }
            this.rowlist.add(this.curCol, value);
            ++this.curCol;
        } else if ("row".equals(name)) {
            this.rowReader.setRows(this.sheetIndex, this.curRow, this.rowlist);
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

