/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.fileanalyzing;

import com.alibaba.fastjson.JSONObject;
import com.cgd.base.fileanalyzing.FileParserResult;
import com.cgd.base.fileanalyzing.ParserFactory;
import com.cgd.base.fileanalyzing.ParserRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFileParser
extends ParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SyncFileParser.class);

    public SyncFileParser(ParserRule parserRule) {
        super(parserRule);
    }

    @Override
    public FileParserResult parse() {
        File file = this.parserRule.getTargetFile();
        FileParserResult fileParserResult = new FileParserResult();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            HashMap<String, String> map = null;
            JSONObject indexToFieldNameRule = this.parserRule.get("keyIndexToFieldName");
            String separator = this.parserRule.getSeparator();
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || !line.contains(separator)) continue;
                line = line.replace("0x0d0x0a", "");
                map = new HashMap<String, String>();
                String[] values = line.split("\\" + separator);
                int len = values.length;
                for (int j = 0; j < len; ++j) {
                    String value = values[j];
                    map.put(indexToFieldNameRule.getString(String.valueOf(j)), value.trim());
                }
                result.add(map);
            }
        }
        catch (Exception ex) {
            LOG.error("TXT\u6309\u7167index\u6a21\u5f0f\u89e3\u6790\u5f02\u5e38|", (Throwable)ex);
        }
        fileParserResult.setData(result);
        fileParserResult.setTotal(result.size());
        return fileParserResult;
    }
}

