/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.cgd.base.mq.MqCunsumer;
import com.cgd.base.mq.MqMessageListener;
import com.cgd.base.mq.NativeMqListener;
import com.cgd.base.mq.ProjectNameUtils;
import com.cgd.common.bo.MqSubScribeSingleBO;
import com.cgd.common.cache.service.CacheService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MqCunsumerSubscribe
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(MqCunsumerSubscribe.class);
    private final boolean isDebugEnabled = LOG.isDebugEnabled();
    private static Map<String, Method> localMethods = new HashMap<String, Method>();
    private CacheService cacheService;
    private Properties props;
    private boolean nativeOns = false;
    private Set<String> excludeConsumerSet = null;
    public static Map<String, MqCunsumer> nativeTopics = new HashMap<String, MqCunsumer>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProjectNameUtils pro;
        this.cacheService = (CacheService)applicationContext.getBean("cacheService", CacheService.class);
        this.props = (Properties)applicationContext.getBean("propertyConfigurer", Properties.class);
        if (applicationContext.containsBean("isIntfaceProject") && (pro = (ProjectNameUtils)applicationContext.getBean("isIntfaceProject", ProjectNameUtils.class)).isNeedExcludeMqConsumer()) {
            String[] excludeConsumers = this.props.getProperty("INTERFACE_MQ_CONSUMER", "").split(",");
            this.excludeConsumerSet = new HashSet<String>(excludeConsumers.length);
            for (String excludeConsumer : excludeConsumers) {
                this.excludeConsumerSet.add(excludeConsumer);
            }
        }
        String accessKey = this.props.getProperty("ons.AccessKey");
        String secretKey = this.props.getProperty("ons.SecretKey");
        String namesrvAddr = this.props.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.props.getProperty("mq.ONSAddr");
        if (LOG.isDebugEnabled()) {
            LOG.debug("MQ\u914d\u7f6enamesrvAddr={},oNSAddr={}", (Object)namesrvAddr, (Object)oNSAddr);
        }
        this.nativeOns = Boolean.parseBoolean(this.props.getProperty("ons.native"));
        Map mqMap = applicationContext.getBeansOfType(MqCunsumer.class);
        for (Map.Entry entry : mqMap.entrySet()) {
            try {
                this.startConsumer(accessKey, secretKey, namesrvAddr, oNSAddr, (MqCunsumer)entry.getValue());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.nativeOns) {
            NativeMqListener mql = new NativeMqListener(this.cacheService);
            mql.start();
        }
    }

    private void startConsumer(String accessKey, String secretKey, String namesrvAddr, String oNSAddr, MqCunsumer mqc) {
        MqSubScribeSingleBO mqBO;
        if (mqc != null && (mqBO = mqc.subscribe()) != null && StringUtils.isNotBlank((CharSequence)mqBO.getConsumerId()) && StringUtils.isNotBlank((CharSequence)mqBO.getTopic()) && StringUtils.isNotBlank((CharSequence)mqBO.getTag())) {
            if (this.excludeContains(mqBO)) {
                return;
            }
            this.logPrint("\u6ce8\u518c\u7684ConsumerId={}", mqBO.getConsumerId());
            String topic = this.props.getProperty(mqBO.getTopic());
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                LOG.error("TOPIC\u662f{}\u5728\u914d\u7f6e\u6587\u4ef6\u672a\u67e5\u5230\uff01\u8bf7\u914d\u7f6e\uff01", (Object)mqBO.getTopic());
            }
            if (this.nativeOns) {
                nativeTopics.put(topic, mqc);
            } else {
                this.remoteMqStart(accessKey, secretKey, namesrvAddr, oNSAddr, mqc, mqBO, topic);
            }
        }
    }

    private void remoteMqStart(String accessKey, String secretKey, String namesrvAddr, String oNSAddr, MqCunsumer mqc, MqSubScribeSingleBO mqBO, String topic) {
        String consumeThreadNumsStr;
        Properties properties = new Properties();
        String consumerId = this.props.getProperty(mqBO.getConsumerId());
        if (StringUtils.isNotBlank((CharSequence)consumerId)) {
            consumerId = consumerId.trim();
        } else {
            LOG.error("\u6d88\u8d39\u8005id\u4e3a{}\u7684\u6d88\u8d39\u8005\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\u8bf7\u914d\u7f6e\uff01", (Object)mqBO.getConsumerId());
        }
        properties.put("ConsumerId", consumerId);
        if (StringUtils.isNotBlank((CharSequence)accessKey)) {
            properties.put("AccessKey", accessKey);
        }
        if (StringUtils.isNotBlank((CharSequence)secretKey)) {
            properties.put("SecretKey", secretKey);
        }
        if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
            properties.put("NAMESRV_ADDR", namesrvAddr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("NAMESRV_ADDR  is  not  null");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
            properties.put("ONSAddr", oNSAddr);
        }
        if (StringUtils.isNotBlank((CharSequence)(consumeThreadNumsStr = this.props.getProperty(mqBO.getConsumerId() + "_THREAD_NUMS")))) {
            int consumeThreadNums = Integer.parseInt(consumeThreadNumsStr.trim());
            properties.put("ConsumeThreadNums", (Object)consumeThreadNums);
        } else {
            properties.put("ConsumeThreadNums", (Object)5);
        }
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.subscribe(topic, mqBO.getTag(), (MessageListener)new MqMessageListener(this.cacheService, mqc, mqBO.getTag()));
        consumer.start();
    }

    private void logPrint(String format, Object obj) {
        if (this.isDebugEnabled) {
            LOG.debug(format, obj);
        }
    }

    private boolean excludeContains(MqSubScribeSingleBO mqBO) {
        if (this.excludeConsumerSet != null && this.excludeConsumerSet.contains(mqBO.getConsumerId())) {
            this.logPrint("\u6392\u9664\u7684ConsumerId={}", mqBO.getConsumerId());
            return true;
        }
        return false;
    }

    private void invokeMethod(Object service, String methodName, Object args) throws InvocationTargetException, IllegalAccessException {
        Method method = localMethods.get(service + methodName);
        if (method == null) {
            Class<?> c = service.getClass();
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                localMethods.put(service + methodName, m);
                method = m;
                break;
            }
        }
        if (method != null) {
            method.invoke(service, args);
        }
    }
}

