/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.cgd.base.mq.NativeOnsProductor;
import com.cgd.common.cache.service.CacheService;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqProducerPool {
    private static final Logger log = LoggerFactory.getLogger(MqProducerPool.class);
    private Properties propertyConfigurer;
    private Map<String, Producer> producers = new HashMap<String, Producer>();
    private boolean nativeOns = false;
    private CacheService cacheService;
    private Map<String, Properties> producerProperties = new HashMap<String, Properties>();
    public static final Map<String, String> producerIds = new HashMap<String, String>();

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
    }

    public Properties getPropertyConfigurer() {
        return this.propertyConfigurer;
    }

    public boolean isNativeOns() {
        return this.nativeOns;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void init() {
        String accessKey = this.propertyConfigurer.getProperty("ons.AccessKey");
        String secretKey = this.propertyConfigurer.getProperty("ons.SecretKey");
        String namesrvAddr = this.propertyConfigurer.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.propertyConfigurer.getProperty("mq.ONSAddr");
        this.nativeOns = Boolean.parseBoolean(this.propertyConfigurer.getProperty("ons.native", "false"));
        for (Object o : this.propertyConfigurer.keySet()) {
            String key = String.valueOf(o);
            if (!key.contains("_PID")) continue;
            String topicKey = key.substring(0, key.length() - 3) + "TOPIC";
            String topic = this.propertyConfigurer.getProperty(topicKey);
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                log.error("TOPIC\u914d\u7f6e\u9519\u4f4d\uff0c\u672a\u627e\u5230\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01");
            }
            NativeOnsProductor producer = null;
            String pid = this.propertyConfigurer.getProperty(key);
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                pid = pid.trim();
            } else {
                log.error("PID\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u627e\u5230\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01");
            }
            if (this.nativeOns) {
                producer = new NativeOnsProductor(this.cacheService);
                producer.start();
            } else {
                Properties properties = MqProducerPool.configRemoteMq(pid, accessKey, secretKey, namesrvAddr, oNSAddr);
                producer = ONSFactory.createProducer((Properties)properties);
                producer.start();
                this.producerProperties.put(topic, properties);
            }
            producerIds.put(topic, pid);
            this.producers.put(topic, producer);
        }
    }

    public static Properties configRemoteMq(String pid, String accessKey, String secretKey, String namesrvAddr, String oNSAddr) {
        Properties properties = new Properties();
        properties.put("ProducerId", pid);
        if (StringUtils.isNotBlank((CharSequence)accessKey)) {
            properties.put("AccessKey", accessKey);
        }
        if (StringUtils.isNotBlank((CharSequence)secretKey)) {
            properties.put("SecretKey", secretKey);
        }
        if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
            properties.put("NAMESRV_ADDR", namesrvAddr);
        }
        if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
            properties.put("ONSAddr", oNSAddr);
        }
        return properties;
    }

    public Producer getProducer(String topic) {
        return this.producers.get(topic);
    }

    public synchronized Producer getSynProducer(String topic) {
        return this.producers.computeIfAbsent(topic, k -> {
            Properties properties = this.producerProperties.get(topic);
            Producer tp = ONSFactory.createProducer((Properties)properties);
            tp.start();
            return tp;
        });
    }
}

