/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import com.cgd.base.util.Command;
import com.cgd.common.exception.ResourceException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class ListUtils {
    private ListUtils() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static <S, T> List<T> copyListProperties(List<S> source, Class<T> clazz) throws ResourceException {
        return ListUtils.copyListProperties(source, clazz, null);
    }

    public static <S, T> List<T> copyListProperties(List<S> source, Class<T> clazz, Command<S, T> command) throws ResourceException {
        ArrayList<T> targets = new ArrayList<T>();
        try {
            for (S s : source) {
                T target = clazz.newInstance();
                BeanUtils.copyProperties(s, target);
                if (null != command) {
                    command.operate(s, target);
                }
                targets.add(target);
            }
        }
        catch (Exception e) {
            throw new ResourceException("7777", "\u5217\u8868\u64cd\u4f5c\u62f7\u8d1d\u9519\u8bef");
        }
        return targets;
    }

    public static <S, T> void exclude(List<S> source, List<T> target, Command<S, T> command) throws ResourceException {
        try {
            block2: for (int i = 0; i < source.size(); ++i) {
                for (int j = 0; j < target.size(); ++j) {
                    if (0 != command.operate(source.get(i), target.get(j))) continue;
                    target.remove(j);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new ResourceException("7777", "\u5217\u6570\u636e\u6392\u9664\u9519\u8bef");
        }
    }

    public static <S, T> void reserve(List<S> source, List<T> target, Command<S, T> command) throws ResourceException {
        try {
            ArrayList<T> tmp = new ArrayList<T>();
            block2: for (int i = 0; i < target.size(); ++i) {
                for (int j = 0; j < source.size(); ++j) {
                    if (0 != command.operate(source.get(j), target.get(i))) continue;
                    tmp.add(target.get(i));
                    continue block2;
                }
            }
            target.clear();
            target.addAll(tmp);
        }
        catch (Exception e) {
            throw new ResourceException("7777", "\u5217\u6570\u636e\u4fdd\u7559\u9519\u8bef");
        }
    }
}

